/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.schema.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class Handler
implements ToNode,
ToSmithyBuilder<Handler> {
    public static final String CREATE = "create";
    public static final String READ = "read";
    public static final String UPDATE = "update";
    public static final String DELETE = "delete";
    public static final String LIST = "list";
    private static final Map<String, Integer> HANDLER_NAME_ORDERS = MapUtils.of((Object)"create", (Object)0, (Object)"read", (Object)1, (Object)"update", (Object)2, (Object)"delete", (Object)3, (Object)"list", (Object)4);
    private final List<String> permissions;

    private Handler(Builder builder) {
        this.permissions = ListUtils.copyOf((Collection)builder.permissions);
    }

    public Node toNode() {
        NodeMapper mapper = new NodeMapper();
        mapper.disableToNodeForClass(Handler.class);
        mapper.setOmitEmptyValues(true);
        return mapper.serialize((Object)this).expectObjectNode();
    }

    public SmithyBuilder<Handler> toBuilder() {
        return Handler.builder().permissions(this.permissions);
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public static Integer getHandlerNameOrder(String name) {
        return HANDLER_NAME_ORDERS.getOrDefault(name, Integer.MAX_VALUE);
    }

    public static final class Builder
    implements SmithyBuilder<Handler> {
        private final List<String> permissions = new ArrayList<String>();

        private Builder() {
        }

        public Handler build() {
            return new Handler(this);
        }

        public Builder permissions(List<String> permissions) {
            this.permissions.clear();
            this.permissions.addAll(permissions);
            return this;
        }

        public Builder addPermission(String permission) {
            this.permissions.add(permission);
            return this;
        }

        public Builder clearPermissions() {
            this.permissions.clear();
            return this;
        }
    }
}

