/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.schema.model;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class Handler
implements ToNode,
ToSmithyBuilder<Handler> {
    public static final String CREATE = "create";
    public static final String READ = "read";
    public static final String UPDATE = "update";
    public static final String DELETE = "delete";
    public static final String LIST = "list";
    private static final Map<String, Integer> HANDLER_NAME_ORDERS = MapUtils.of((Object)"create", (Object)0, (Object)"read", (Object)1, (Object)"update", (Object)2, (Object)"delete", (Object)3, (Object)"list", (Object)4);
    private final Set<String> permissions;

    private Handler(Builder builder) {
        this.permissions = (Set)builder.permissions.copy();
    }

    public Node toNode() {
        NodeMapper mapper = new NodeMapper();
        mapper.disableToNodeForClass(Handler.class);
        mapper.setOmitEmptyValues(true);
        return mapper.serialize((Object)this).expectObjectNode();
    }

    public Builder toBuilder() {
        return Handler.builder().permissions(this.permissions);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Set<String> getPermissions() {
        return this.permissions;
    }

    public static Integer getHandlerNameOrder(String name) {
        return HANDLER_NAME_ORDERS.getOrDefault(name, Integer.MAX_VALUE);
    }

    public static final class Builder
    implements SmithyBuilder<Handler> {
        private final BuilderRef<Set<String>> permissions = BuilderRef.forSortedSet();

        private Builder() {
        }

        public Handler build() {
            return new Handler(this);
        }

        public Builder permissions(Collection<String> permissions) {
            this.permissions.clear();
            permissions.forEach(this::addPermission);
            return this;
        }

        public Builder addPermission(String permission) {
            ((Set)this.permissions.get()).add(permission);
            return this;
        }

        public Builder clearPermissions() {
            this.permissions.clear();
            return this;
        }
    }
}

