/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.schema.fromsmithy;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import software.amazon.smithy.aws.cloudformation.schema.CfnConfig;
import software.amazon.smithy.aws.cloudformation.schema.CfnException;
import software.amazon.smithy.aws.cloudformation.schema.fromsmithy.CfnMapper;
import software.amazon.smithy.aws.cloudformation.schema.fromsmithy.Context;
import software.amazon.smithy.aws.cloudformation.schema.fromsmithy.Smithy2CfnExtension;
import software.amazon.smithy.aws.cloudformation.schema.fromsmithy.mappers.TaggingMapper;
import software.amazon.smithy.aws.cloudformation.schema.model.Property;
import software.amazon.smithy.aws.cloudformation.schema.model.ResourceSchema;
import software.amazon.smithy.aws.cloudformation.traits.CfnNameTrait;
import software.amazon.smithy.aws.cloudformation.traits.CfnResource;
import software.amazon.smithy.aws.cloudformation.traits.CfnResourceIndex;
import software.amazon.smithy.aws.cloudformation.traits.CfnResourceTrait;
import software.amazon.smithy.aws.traits.ServiceTrait;
import software.amazon.smithy.jsonschema.JsonSchemaConfig;
import software.amazon.smithy.jsonschema.JsonSchemaConverter;
import software.amazon.smithy.jsonschema.JsonSchemaMapper;
import software.amazon.smithy.jsonschema.PropertyNamingStrategy;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.jsonschema.SchemaDocument;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.DocumentationTrait;
import software.amazon.smithy.model.traits.PropertyTrait;
import software.amazon.smithy.model.traits.StringTrait;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.StringUtils;

public final class CfnConverter {
    private ClassLoader classLoader = CfnConverter.class.getClassLoader();
    private CfnConfig config = new CfnConfig();
    private final List<Smithy2CfnExtension> extensions = new ArrayList<Smithy2CfnExtension>();

    private CfnConverter() {
    }

    public static CfnConverter create() {
        return new CfnConverter();
    }

    public CfnConfig getConfig() {
        return this.config;
    }

    public CfnConverter config(CfnConfig config) {
        this.config = config;
        return this;
    }

    public CfnConverter classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public Map<String, ObjectNode> convertToNodes(Model model) {
        List<ConversionEnvironment> environments = this.createConversionEnvironments(model);
        Map<ShapeId, ResourceSchema> resources = this.convertWithEnvironments(environments);
        HashMap<String, ObjectNode> convertedNodes = new HashMap<String, ObjectNode>();
        for (ConversionEnvironment environment : environments) {
            ResourceSchema resourceSchema = resources.get(environment.context.getResource().getId());
            ObjectNode node = resourceSchema.toNode().expectObjectNode();
            for (CfnMapper mapper : environment.mappers) {
                node = mapper.updateNode(environment.context, resourceSchema, node);
            }
            node = node.withMember("additionalProperties", false);
            convertedNodes.put(resourceSchema.getTypeName(), node);
        }
        return convertedNodes;
    }

    public List<ResourceSchema> convert(Model model) {
        return ListUtils.copyOf(this.convertWithEnvironments(this.createConversionEnvironments(model)).values());
    }

    private Map<ShapeId, ResourceSchema> convertWithEnvironments(List<ConversionEnvironment> environments) {
        HashMap<ShapeId, ResourceSchema> resourceSchemas = new HashMap<ShapeId, ResourceSchema>();
        for (ConversionEnvironment environment : environments) {
            ResourceShape resourceShape = environment.context.getResource();
            ResourceSchema resourceSchema = this.convertResource(environment, resourceShape);
            resourceSchemas.put(resourceShape.getId(), resourceSchema);
        }
        return resourceSchemas;
    }

    private List<ConversionEnvironment> createConversionEnvironments(Model model) {
        ShapeId serviceShapeId = this.config.getService();
        if (serviceShapeId == null) {
            throw new CfnException("cloudformation is missing required property, `service`");
        }
        ServiceLoader.load(Smithy2CfnExtension.class, this.classLoader).forEach(this.extensions::add);
        ServiceShape serviceShape = (ServiceShape)model.expectShape(serviceShapeId, ServiceShape.class);
        TopDownIndex topDownIndex = TopDownIndex.of((Model)model);
        Set resourceShapes = topDownIndex.getContainedResources((ToShapeId)serviceShape);
        ArrayList<ConversionEnvironment> environments = new ArrayList<ConversionEnvironment>();
        for (ResourceShape resourceShape : resourceShapes) {
            if (!resourceShape.hasTrait(CfnResourceTrait.ID)) continue;
            ConversionEnvironment environment = this.createConversionEnvironment(model, serviceShape, resourceShape);
            environments.add(environment);
        }
        return environments;
    }

    private ConversionEnvironment createConversionEnvironment(Model model, ServiceShape serviceShape, ResourceShape resourceShape) {
        JsonSchemaConverter.Builder jsonSchemaConverterBuilder = JsonSchemaConverter.builder().config((JsonSchemaConfig)this.config).propertyNamingStrategy(this.getPropertyNamingStrategy());
        ArrayList<CfnMapper> mappers = new ArrayList<CfnMapper>();
        for (Smithy2CfnExtension extension : this.extensions) {
            mappers.addAll(extension.getCfnMappers());
            for (JsonSchemaMapper mapper : extension.getJsonSchemaMappers()) {
                jsonSchemaConverterBuilder.addMapper(mapper);
            }
        }
        mappers.sort(Comparator.comparingInt(CfnMapper::getOrder));
        CfnResourceIndex resourceIndex = CfnResourceIndex.of((Model)model);
        CfnResource cfnResource = (CfnResource)resourceIndex.getResource((ToShapeId)resourceShape).orElseThrow(() -> new CfnException("Attempted to generate a CloudFormation resource schema not found to have resource data."));
        StructureShape pseudoResource = this.getCfnResourceStructure(model, resourceShape, cfnResource);
        Model updatedModel = model.toBuilder().addShape((Shape)pseudoResource).build();
        jsonSchemaConverterBuilder.model(updatedModel);
        Context context = new Context(updatedModel, serviceShape, resourceShape, cfnResource, pseudoResource, this.config, jsonSchemaConverterBuilder.build());
        return new ConversionEnvironment(context, mappers);
    }

    private PropertyNamingStrategy getPropertyNamingStrategy() {
        return (containingShape, member, config) -> {
            Optional cfnNameTrait = member.getTrait(CfnNameTrait.class);
            if (cfnNameTrait.isPresent()) {
                return ((CfnNameTrait)cfnNameTrait.get()).getValue();
            }
            Optional propertyTrait = member.getTrait(PropertyTrait.class);
            if (propertyTrait.isPresent() && propertyTrait.flatMap(PropertyTrait::getName).isPresent()) {
                return this.config.getDisableCapitalizedProperties() ? StringUtils.capitalize((String)((String)((PropertyTrait)propertyTrait.get()).getName().get())) : (String)((PropertyTrait)propertyTrait.get()).getName().get();
            }
            String name = PropertyNamingStrategy.createMemberNameStrategy().toPropertyName(containingShape, member, config);
            return this.config.getDisableCapitalizedProperties() ? name : StringUtils.capitalize((String)name);
        };
    }

    private ResourceSchema convertResource(ConversionEnvironment environment, ResourceShape resourceShape) {
        Context context = environment.context;
        JsonSchemaConverter jsonSchemaConverter = context.getJsonSchemaConverter().toBuilder().rootShape((ToShapeId)context.getResourceStructure()).build();
        SchemaDocument document = jsonSchemaConverter.convert();
        CfnResourceTrait resourceTrait = (CfnResourceTrait)resourceShape.expectTrait(CfnResourceTrait.class);
        ResourceSchema.Builder builder = ResourceSchema.builder();
        String typeName = this.resolveResourceTypeName(environment, resourceTrait);
        builder.typeName(typeName);
        builder.description(resourceShape.getTrait(DocumentationTrait.class).map(StringTrait::getValue).orElse("Definition of " + typeName + " Resource Type"));
        for (CfnMapper cfnMapper : environment.mappers) {
            cfnMapper.before(context, builder);
        }
        document.getRootSchema().getProperties().forEach((name, schema) -> {
            Property property = Property.builder().schema((Schema)schema).build();
            builder.addProperty((String)name, property);
        });
        for (Map.Entry entry : document.getDefinitions().entrySet()) {
            String definitionName = ((String)entry.getKey()).replace("#/definitions", "").substring(1);
            builder.addDefinition(definitionName, (Schema)entry.getValue());
        }
        ResourceSchema resourceSchema = builder.build();
        for (CfnMapper mapper : environment.mappers) {
            resourceSchema = mapper.after(context, resourceSchema);
        }
        return resourceSchema;
    }

    private String resolveResourceTypeName(ConversionEnvironment environment, CfnResourceTrait resourceTrait) {
        String serviceName;
        CfnConfig config = environment.context.getConfig();
        ServiceShape serviceShape = (ServiceShape)environment.context.getModel().expectShape(config.getService(), ServiceShape.class);
        Optional serviceTrait = serviceShape.getTrait(ServiceTrait.class);
        String organizationName = config.getOrganizationName();
        if (organizationName == null) {
            organizationName = serviceTrait.map(t -> "AWS").orElseThrow(() -> new CfnException("cloudformation is missing required property, `organizationName`"));
        }
        if ((serviceName = config.getServiceName()) == null) {
            serviceName = serviceTrait.map(ServiceTrait::getCloudFormationName).orElse(serviceShape.getId().getName());
        }
        String resourceName = resourceTrait.getName().orElse(environment.context.getResource().getId().getName());
        return String.format("%s::%s::%s", organizationName, serviceName, resourceName);
    }

    private StructureShape getCfnResourceStructure(Model model, ResourceShape resource, CfnResource cfnResource) {
        StructureShape.Builder builder = StructureShape.builder();
        ShapeId resourceId = resource.getId();
        builder.id(ShapeId.fromParts((String)resourceId.getNamespace(), (String)(resourceId.getName() + "__SYNTHETIC__")));
        cfnResource.getProperties().forEach((name, definition) -> {
            Shape definitionShape = model.expectShape(definition.getShapeId());
            if (definitionShape.isMemberShape()) {
                MemberShape member = (MemberShape)definitionShape.asMemberShape().get();
                member = ((MemberShape.Builder)member.toBuilder().id(builder.getId().withMember(name))).build();
                builder.addMember(member);
            } else {
                builder.addMember(name, definition.getShapeId());
            }
        });
        TaggingMapper.injectTagsMember(this.config, model, resource, builder);
        return builder.build();
    }

    private static final class ConversionEnvironment {
        private final Context context;
        private final List<CfnMapper> mappers;

        private ConversionEnvironment(Context context, List<CfnMapper> mappers) {
            this.context = context;
            this.mappers = mappers;
        }
    }
}

