/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.schema.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class Property
implements ToNode,
ToSmithyBuilder<Property> {
    private final boolean insertionOrder;
    private final List<String> dependencies;
    private final Schema schema;

    private Property(Builder builder) {
        this.insertionOrder = builder.insertionOrder;
        this.dependencies = ListUtils.copyOf((Collection)builder.dependencies);
        this.schema = builder.schema;
    }

    public Node toNode() {
        ObjectNode.Builder builder = this.schema.toNode().expectObjectNode().toBuilder();
        if (this.insertionOrder) {
            builder.withMember("insertionOrder", (ToNode)Node.from((boolean)this.insertionOrder));
        }
        if (!this.dependencies.isEmpty()) {
            builder.withMember("dependencies", (ToNode)Node.fromStrings(this.dependencies));
        }
        return builder.build();
    }

    public SmithyBuilder<Property> toBuilder() {
        return Property.builder().insertionOrder(this.insertionOrder).dependencies(this.dependencies).schema(this.schema);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isInsertionOrder() {
        return this.insertionOrder;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public static final class Builder
    implements SmithyBuilder<Property> {
        private boolean insertionOrder = false;
        private final List<String> dependencies = new ArrayList<String>();
        private Schema schema;

        private Builder() {
        }

        public Property build() {
            return new Property(this);
        }

        public Builder insertionOrder(boolean insertionOrder) {
            this.insertionOrder = insertionOrder;
            return this;
        }

        public Builder dependencies(List<String> dependencies) {
            this.dependencies.clear();
            this.dependencies.addAll(dependencies);
            return this;
        }

        public Builder addDependency(String dependency) {
            this.dependencies.add(dependency);
            return this;
        }

        public Builder clearDependencies() {
            this.dependencies.clear();
            return this;
        }

        public Builder schema(Schema schema) {
            this.schema = schema;
            return this;
        }
    }
}

