/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.schema.fromsmithy.mappers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.aws.cloudformation.schema.fromsmithy.CfnMapper;
import software.amazon.smithy.aws.cloudformation.schema.fromsmithy.Context;
import software.amazon.smithy.aws.cloudformation.schema.model.ResourceSchema;
import software.amazon.smithy.aws.cloudformation.traits.CfnResource;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
final class IdentifierMapper
implements CfnMapper {
    IdentifierMapper() {
    }

    @Override
    public void before(Context context, ResourceSchema.Builder builder) {
        CfnResource cfnResource = context.getCfnResource();
        Set primaryIdentifier = cfnResource.getPrimaryIdentifiers();
        builder.primaryIdentifier(primaryIdentifier.stream().map(context::getPropertyPointer).collect(Collectors.toList()));
        List additionalIdentifiers = cfnResource.getAdditionalIdentifiers();
        for (Set additionalIdentifier : additionalIdentifiers) {
            ArrayList<String> additionalIdentifierPointers = new ArrayList<String>();
            for (String additionalIdentifierName : additionalIdentifier) {
                additionalIdentifierPointers.add(context.getPropertyPointer(additionalIdentifierName));
            }
            builder.addAdditionalIdentifier(additionalIdentifierPointers);
        }
    }
}

