/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.schema.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import software.amazon.smithy.aws.cloudformation.schema.CfnException;
import software.amazon.smithy.aws.cloudformation.schema.model.Handler;
import software.amazon.smithy.aws.cloudformation.schema.model.Property;
import software.amazon.smithy.aws.cloudformation.schema.model.Remote;
import software.amazon.smithy.aws.cloudformation.schema.model.Tagging;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ResourceSchema
implements ToNode,
ToSmithyBuilder<ResourceSchema> {
    private final String typeName;
    private final String description;
    private final String sourceUrl;
    private final String documentationUrl;
    private final Map<String, Schema> definitions = new TreeMap<String, Schema>();
    private final Map<String, Property> properties = new TreeMap<String, Property>();
    private final Set<String> required = new TreeSet<String>();
    private final Set<String> readOnlyProperties = new TreeSet<String>();
    private final Set<String> writeOnlyProperties = new TreeSet<String>();
    private final Set<String> primaryIdentifier = new TreeSet<String>();
    private final Set<String> createOnlyProperties = new TreeSet<String>();
    private final Set<String> deprecatedProperties = new TreeSet<String>();
    private final List<List<String>> additionalIdentifiers;
    private final Map<String, Handler> handlers = new TreeMap<String, Handler>(Comparator.comparing(Handler::getHandlerNameOrder));
    private final Map<String, Remote> remotes = new TreeMap<String, Remote>();
    private final Tagging tagging;
    private final Schema additionalProperties;

    private ResourceSchema(Builder builder) {
        this.typeName = (String)SmithyBuilder.requiredState((String)"typeName", (Object)builder.typeName);
        this.description = (String)SmithyBuilder.requiredState((String)"description", (Object)builder.description);
        if (builder.properties.isEmpty()) {
            throw new CfnException(String.format("Expected CloudFormation resource %s to have properties, found none", this.typeName));
        }
        this.properties.putAll(builder.properties);
        this.required.addAll(builder.required);
        this.sourceUrl = builder.sourceUrl;
        this.documentationUrl = builder.documentationUrl;
        this.definitions.putAll(builder.definitions);
        this.readOnlyProperties.addAll(builder.readOnlyProperties);
        this.writeOnlyProperties.addAll(builder.writeOnlyProperties);
        this.primaryIdentifier.addAll(builder.primaryIdentifier);
        this.createOnlyProperties.addAll(builder.createOnlyProperties);
        this.deprecatedProperties.addAll(builder.deprecatedProperties);
        this.additionalIdentifiers = ListUtils.copyOf((Collection)builder.additionalIdentifiers);
        this.handlers.putAll(builder.handlers);
        this.remotes.putAll(builder.remotes);
        this.tagging = builder.tagging;
        this.additionalProperties = builder.additionalProperties;
    }

    public Node toNode() {
        NodeMapper mapper = new NodeMapper();
        ObjectNode.Builder builder = Node.objectNodeBuilder();
        builder.withMember("typeName", this.typeName);
        builder.withMember("description", this.description);
        this.getSourceUrl().ifPresent(sourceUrl -> builder.withMember("sourceUrl", sourceUrl));
        this.getDocumentationUrl().ifPresent(documentationUrl -> builder.withMember("documentationUrl", documentationUrl));
        if (!this.definitions.isEmpty()) {
            builder.withMember("definitions", (ToNode)mapper.serialize(this.definitions));
        }
        builder.withMember("properties", (ToNode)mapper.serialize(this.properties));
        if (!this.required.isEmpty()) {
            builder.withMember("required", (ToNode)mapper.serialize(this.required));
        }
        if (!this.readOnlyProperties.isEmpty()) {
            builder.withMember("readOnlyProperties", (ToNode)mapper.serialize(this.readOnlyProperties));
        }
        if (!this.writeOnlyProperties.isEmpty()) {
            builder.withMember("writeOnlyProperties", (ToNode)mapper.serialize(this.writeOnlyProperties));
        }
        if (!this.createOnlyProperties.isEmpty()) {
            builder.withMember("createOnlyProperties", (ToNode)mapper.serialize(this.createOnlyProperties));
        }
        if (!this.deprecatedProperties.isEmpty()) {
            builder.withMember("deprecatedProperties", (ToNode)mapper.serialize(this.deprecatedProperties));
        }
        if (!this.primaryIdentifier.isEmpty()) {
            builder.withMember("primaryIdentifier", (ToNode)mapper.serialize(this.primaryIdentifier));
        }
        if (!this.additionalIdentifiers.isEmpty()) {
            builder.withMember("additionalIdentifiers", (ToNode)mapper.serialize(this.additionalIdentifiers));
        }
        if (!this.handlers.isEmpty()) {
            builder.withMember("handlers", (ToNode)mapper.serialize(this.handlers));
        }
        if (!this.remotes.isEmpty()) {
            builder.withMember("remotes", (ToNode)mapper.serialize(this.remotes));
        }
        if (this.tagging != null) {
            builder.withMember("tagging", (ToNode)mapper.serialize((Object)this.tagging));
        }
        if (this.additionalProperties != null) {
            builder.withMember("additionalProperties", (ToNode)mapper.serialize((Object)this.additionalProperties));
        }
        return builder.build();
    }

    public Builder toBuilder() {
        return ResourceSchema.builder().typeName(this.typeName).description(this.description).sourceUrl(this.sourceUrl).documentationUrl(this.documentationUrl).definitions(this.definitions).properties(this.properties).required(this.required).readOnlyProperties(this.readOnlyProperties).writeOnlyProperties(this.writeOnlyProperties).primaryIdentifier(this.primaryIdentifier).createOnlyProperties(this.createOnlyProperties).deprecatedProperties(this.deprecatedProperties).additionalIdentifiers(this.additionalIdentifiers).handlers(this.handlers).remotes(this.remotes).tagging(this.tagging);
    }

    public static ResourceSchema fromNode(Node node) {
        NodeMapper mapper = new NodeMapper();
        return ((Builder)mapper.deserializeInto(node, (Object)ResourceSchema.builder())).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getDescription() {
        return this.description;
    }

    public Optional<String> getSourceUrl() {
        return Optional.ofNullable(this.sourceUrl);
    }

    public Optional<String> getDocumentationUrl() {
        return Optional.ofNullable(this.documentationUrl);
    }

    public Map<String, Schema> getDefinitions() {
        return this.definitions;
    }

    public Map<String, Property> getProperties() {
        return this.properties;
    }

    public Set<String> getReadOnlyProperties() {
        return this.readOnlyProperties;
    }

    public Set<String> getWriteOnlyProperties() {
        return this.writeOnlyProperties;
    }

    public Set<String> getPrimaryIdentifier() {
        return this.primaryIdentifier;
    }

    public Set<String> getCreateOnlyProperties() {
        return this.createOnlyProperties;
    }

    public Set<String> getDeprecatedProperties() {
        return this.deprecatedProperties;
    }

    public List<List<String>> getAdditionalIdentifiers() {
        return this.additionalIdentifiers;
    }

    public Map<String, Handler> getHandlers() {
        return this.handlers;
    }

    public Map<String, Remote> getRemotes() {
        return this.remotes;
    }

    public Tagging getTagging() {
        return this.tagging;
    }

    public static final class Builder
    implements SmithyBuilder<ResourceSchema> {
        private String typeName;
        private String description;
        private String sourceUrl;
        private String documentationUrl;
        private final Map<String, Schema> definitions = new TreeMap<String, Schema>();
        private final Map<String, Property> properties = new TreeMap<String, Property>();
        private final Set<String> required = new TreeSet<String>();
        private final Set<String> readOnlyProperties = new TreeSet<String>();
        private final Set<String> writeOnlyProperties = new TreeSet<String>();
        private final Set<String> primaryIdentifier = new TreeSet<String>();
        private final Set<String> createOnlyProperties = new TreeSet<String>();
        private final Set<String> deprecatedProperties = new TreeSet<String>();
        private final List<List<String>> additionalIdentifiers = new ArrayList<List<String>>();
        private final Map<String, Handler> handlers = new TreeMap<String, Handler>();
        private final Map<String, Remote> remotes = new TreeMap<String, Remote>();
        private Tagging tagging;
        private Schema additionalProperties;

        private Builder() {
        }

        public ResourceSchema build() {
            return new ResourceSchema(this);
        }

        public Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder sourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
            return this;
        }

        public Builder documentationUrl(String documentationUrl) {
            this.documentationUrl = documentationUrl;
            return this;
        }

        public Builder definitions(Map<String, Schema> definitions) {
            this.definitions.clear();
            this.definitions.putAll(definitions);
            return this;
        }

        public Builder addDefinition(String name, Schema definition) {
            this.definitions.put(name, definition);
            return this;
        }

        public Builder removeDefinition(String name) {
            this.definitions.remove(name);
            return this;
        }

        public Builder clearDefinitions() {
            this.definitions.clear();
            return this;
        }

        public Builder properties(Map<String, Property> properties) {
            this.properties.clear();
            this.properties.putAll(properties);
            return this;
        }

        public Builder addProperty(String name, Property property) {
            this.properties.put(name, property);
            return this;
        }

        public Builder removeProperty(String name) {
            this.properties.remove(name);
            return this;
        }

        public Builder clearProperties() {
            this.properties.clear();
            return this;
        }

        public Builder required(Collection<String> required) {
            this.required.clear();
            this.required.addAll(required);
            return this;
        }

        public Builder addRequired(String required) {
            this.required.add(required);
            return this;
        }

        public Builder removeRequired(String required) {
            this.required.remove(required);
            return this;
        }

        public Builder clearRequired() {
            this.required.clear();
            return this;
        }

        public Builder addReadOnlyProperty(String propertyRef) {
            this.readOnlyProperties.add(propertyRef);
            return this;
        }

        public Builder readOnlyProperties(Collection<String> readOnlyProperties) {
            this.readOnlyProperties.clear();
            this.readOnlyProperties.addAll(readOnlyProperties);
            return this;
        }

        public Builder clearReadOnlyProperties() {
            this.readOnlyProperties.clear();
            return this;
        }

        public Builder addWriteOnlyProperty(String propertyRef) {
            this.writeOnlyProperties.add(propertyRef);
            return this;
        }

        public Builder writeOnlyProperties(Collection<String> writeOnlyProperties) {
            this.writeOnlyProperties.clear();
            this.writeOnlyProperties.addAll(writeOnlyProperties);
            return this;
        }

        public Builder clearWriteOnlyProperties() {
            this.writeOnlyProperties.clear();
            return this;
        }

        public Builder primaryIdentifier(Collection<String> primaryIdentifier) {
            this.primaryIdentifier.clear();
            this.primaryIdentifier.addAll(primaryIdentifier);
            return this;
        }

        public Builder clearPrimaryIdentifier() {
            this.primaryIdentifier.clear();
            return this;
        }

        public Builder addCreateOnlyProperty(String propertyRef) {
            this.createOnlyProperties.add(propertyRef);
            return this;
        }

        public Builder createOnlyProperties(Collection<String> createOnlyProperties) {
            this.createOnlyProperties.clear();
            this.createOnlyProperties.addAll(createOnlyProperties);
            return this;
        }

        public Builder clearCreateOnlyProperties() {
            this.createOnlyProperties.clear();
            return this;
        }

        public Builder addDeprecatedProperty(String propertyRef) {
            this.deprecatedProperties.add(propertyRef);
            return this;
        }

        public Builder deprecatedProperties(Collection<String> deprecatedProperties) {
            this.deprecatedProperties.clear();
            this.deprecatedProperties.addAll(deprecatedProperties);
            return this;
        }

        public Builder clearDeprecatedProperties() {
            this.deprecatedProperties.clear();
            return this;
        }

        public Builder addAdditionalIdentifier(List<String> additionalIdentifier) {
            this.additionalIdentifiers.add(additionalIdentifier);
            return this;
        }

        public Builder additionalIdentifiers(List<List<String>> additionalIdentifiers) {
            this.additionalIdentifiers.clear();
            this.additionalIdentifiers.addAll(additionalIdentifiers);
            return this;
        }

        public Builder clearAdditionalIdentifiers() {
            this.additionalIdentifiers.clear();
            return this;
        }

        public Builder handlers(Map<String, Handler> handlers) {
            this.handlers.clear();
            this.handlers.putAll(handlers);
            return this;
        }

        public Builder addHandler(String name, Handler handler) {
            this.handlers.put(name, handler);
            return this;
        }

        public Builder removeHandler(String name) {
            this.handlers.remove(name);
            return this;
        }

        public Builder clearHandlers() {
            this.handlers.clear();
            return this;
        }

        public Builder remotes(Map<String, Remote> remotes) {
            this.remotes.clear();
            this.remotes.putAll(remotes);
            return this;
        }

        public Builder tagging(Tagging tagging) {
            this.tagging = tagging;
            return this;
        }

        public Builder addRemote(String name, Remote remote) {
            this.remotes.put(name, remote);
            return this;
        }

        public Builder removeRemote(String name) {
            this.remotes.remove(name);
            return this;
        }

        public Builder clearRemotes() {
            this.remotes.clear();
            return this;
        }

        public Builder additionalProperties(Schema additionalProperties) {
            this.additionalProperties = additionalProperties;
            return this;
        }
    }
}

