/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.schema;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import software.amazon.smithy.aws.cloudformation.schema.CfnException;
import software.amazon.smithy.jsonschema.JsonSchemaConfig;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.utils.ListUtils;

public final class CfnConfig
extends JsonSchemaConfig {
    public static final String SCHEMA_COMPONENTS_POINTER = "#/definitions";
    private static final Logger LOGGER = Logger.getLogger(CfnConfig.class.getName());
    private boolean disableDeprecatedPropertyGeneration = false;
    private boolean disableCapitalizedProperties = false;
    private List<String> externalDocs = ListUtils.of((Object[])new String[]{"Documentation Url", "DocumentationUrl", "API Reference", "User Guide", "Developer Guide", "Reference", "Guide"});
    private Map<ShapeId, Map<String, Node>> jsonAdd = Collections.emptyMap();
    private String organizationName;
    private String serviceName;
    private ShapeId service;
    private List<String> sourceDocs = ListUtils.of((Object[])new String[]{"Source Url", "SourceUrl", "Source", "Source Code"});

    public CfnConfig() {
        super.setAlphanumericOnlyRefs(true);
        this.setDefinitionPointer(SCHEMA_COMPONENTS_POINTER);
        super.setMapStrategy(JsonSchemaConfig.MapStrategy.PATTERN_PROPERTIES);
        super.setUnionStrategy(JsonSchemaConfig.UnionStrategy.ONE_OF);
    }

    public void setAlphanumericOnlyRefs(boolean alphanumericOnlyRefs) {
        if (!alphanumericOnlyRefs) {
            throw new CfnException("CloudFormation Resource Schemas MUST use alphanumeric only references. `alphanumericOnlyRefs` value of `false` was provided.");
        }
    }

    public boolean getDisableDeprecatedPropertyGeneration() {
        return this.disableDeprecatedPropertyGeneration;
    }

    public void setDisableDeprecatedPropertyGeneration(boolean disableDeprecatedPropertyGeneration) {
        this.disableDeprecatedPropertyGeneration = disableDeprecatedPropertyGeneration;
    }

    public boolean getDisableCapitalizedProperties() {
        return this.disableCapitalizedProperties;
    }

    public void setDisableCapitalizedProperties(boolean disableCapitalizedProperties) {
        this.disableCapitalizedProperties = disableCapitalizedProperties;
    }

    public List<String> getExternalDocs() {
        return this.externalDocs;
    }

    public void setExternalDocs(List<String> externalDocs) {
        this.externalDocs = externalDocs;
    }

    public Map<ShapeId, Map<String, Node>> getJsonAdd() {
        return this.jsonAdd;
    }

    public void setJsonAdd(Map<ShapeId, Map<String, Node>> jsonAdd) {
        this.jsonAdd = Objects.requireNonNull(jsonAdd);
    }

    public void setUseJsonName(boolean useJsonName) {
        throw new CfnException(String.format("CloudFormation Resource Schemas use the `@cfnName` trait for naming JSON Schema properties for structures and unions. `useJsonName` value of `%b` was provided.", useJsonName));
    }

    public void setMapStrategy(JsonSchemaConfig.MapStrategy mapStrategy) {
        if (mapStrategy != JsonSchemaConfig.MapStrategy.PATTERN_PROPERTIES) {
            throw new CfnException(String.format("CloudFormation Resource Schemas require the use of `patternProperties` for defining maps in JSON Schema. `mapStrategy` value of `%s` was provided.", mapStrategy));
        }
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public ShapeId getService() {
        return this.service;
    }

    public void setService(ShapeId service) {
        this.service = service;
    }

    public List<String> getSourceDocs() {
        return this.sourceDocs;
    }

    public void setSourceDocs(List<String> sourceDocs) {
        this.sourceDocs = sourceDocs;
    }

    public void setUnionStrategy(JsonSchemaConfig.UnionStrategy unionStrategy) {
        if (unionStrategy != JsonSchemaConfig.UnionStrategy.ONE_OF) {
            throw new CfnException(String.format("CloudFormation Resource Schemas require the use of `oneOf` for defining unions in JSON Schema. `unionStrategy` value of `%s` was provided.", unionStrategy));
        }
    }

    public static CfnConfig fromNode(Node settings) {
        NodeMapper mapper = new NodeMapper();
        mapper.setWhenMissingSetter(NodeMapper.WhenMissing.INGORE);
        ObjectNode node = settings.expectObjectNode();
        CfnConfig config = new CfnConfig();
        mapper.deserializeInto((Node)node, (Object)config);
        for (Map.Entry entry : node.getStringMap().entrySet()) {
            config.putExtension((String)entry.getKey(), (Node)entry.getValue());
        }
        return config;
    }
}

