/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.schema.fromsmithy.mappers;

import software.amazon.smithy.aws.cloudformation.schema.fromsmithy.CfnMapper;
import software.amazon.smithy.aws.cloudformation.schema.fromsmithy.Context;
import software.amazon.smithy.aws.cloudformation.schema.model.ResourceSchema;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.DeprecatedTrait;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
final class DeprecatedMapper
implements CfnMapper {
    DeprecatedMapper() {
    }

    @Override
    public void before(Context context, ResourceSchema.Builder resourceSchema) {
        if (context.getConfig().getDisableDeprecatedPropertyGeneration()) {
            return;
        }
        Model model = context.getModel();
        StructureShape resourceStructure = context.getResourceStructure();
        for (MemberShape member : resourceStructure.members()) {
            if (!member.getMemberTrait(model, DeprecatedTrait.class).isPresent()) continue;
            resourceSchema.addDeprecatedProperty(context.getPropertyPointer(member.getMemberName()));
        }
    }
}

