/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.schema.fromsmithy.mappers;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import software.amazon.smithy.aws.cloudformation.schema.fromsmithy.CfnMapper;
import software.amazon.smithy.aws.cloudformation.schema.fromsmithy.Context;
import software.amazon.smithy.aws.cloudformation.schema.model.ResourceSchema;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;

final class AdditionalPropertiesMapper
implements CfnMapper {
    AdditionalPropertiesMapper() {
    }

    @Override
    public byte getOrder() {
        return 124;
    }

    @Override
    public ObjectNode updateNode(Context context, ResourceSchema resourceSchema, ObjectNode node) {
        Optional definitionsOptional = node.getObjectMember("definitions");
        LinkedHashMap<StringNode, Node> updatedNodes = new LinkedHashMap<StringNode, Node>();
        if (definitionsOptional.isPresent()) {
            for (Map.Entry entry : ((ObjectNode)definitionsOptional.get()).getMembers().entrySet()) {
                ObjectNode valueNode = ((Node)entry.getValue()).expectObjectNode();
                updatedNodes.put((StringNode)entry.getKey(), this.addAdditionalProperties((Node)valueNode));
            }
            node = node.withMember("definitions", (ToNode)Node.objectNode(updatedNodes));
        }
        return node;
    }

    private Node addAdditionalProperties(Node node) {
        if (!node.isObjectNode()) {
            return node;
        }
        ObjectNode valueNode = node.expectObjectNode();
        Optional<String> type = valueNode.getStringMember("type").map(StringNode::getValue);
        if (!type.isPresent() && valueNode.getArrayMember("oneOf").isPresent()) {
            List elements = valueNode.expectArrayMember("oneOf").getElements();
            ArrayList<Node> updatedElements = new ArrayList<Node>(elements.size());
            for (Node element : elements) {
                updatedElements.add(this.addAdditionalProperties(element));
            }
            valueNode = valueNode.withMember("oneOf", (ToNode)ArrayNode.fromNodes(updatedElements));
        } else if (type.isPresent() && type.get().equals("object")) {
            valueNode = valueNode.withMember("additionalProperties", false);
        }
        return valueNode;
    }
}

