/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.schema.fromsmithy;

import software.amazon.smithy.aws.cloudformation.schema.CfnConfig;
import software.amazon.smithy.aws.cloudformation.traits.CfnResource;
import software.amazon.smithy.jsonschema.JsonSchemaConverter;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.StructureShape;

public final class Context {
    private final Model model;
    private final ServiceShape service;
    private final ResourceShape resource;
    private final CfnResource cfnResource;
    private final StructureShape resourceStructure;
    private final JsonSchemaConverter jsonSchemaConverter;
    private final CfnConfig config;

    Context(Model model, ServiceShape service, ResourceShape resource, CfnResource cfnResource, StructureShape resourceStructure, CfnConfig config, JsonSchemaConverter jsonSchemaConverter) {
        this.model = model;
        this.service = service;
        this.resource = resource;
        this.cfnResource = cfnResource;
        this.resourceStructure = resourceStructure;
        this.config = config;
        this.jsonSchemaConverter = jsonSchemaConverter;
    }

    public Model getModel() {
        return this.model;
    }

    public ServiceShape getService() {
        return this.service;
    }

    public ResourceShape getResource() {
        return this.resource;
    }

    public CfnResource getCfnResource() {
        return this.cfnResource;
    }

    public StructureShape getResourceStructure() {
        return this.resourceStructure;
    }

    public CfnConfig getConfig() {
        return this.config;
    }

    public JsonSchemaConverter getJsonSchemaConverter() {
        return this.jsonSchemaConverter;
    }

    public String getPropertyPointer(String propertyName) {
        MemberShape member = (MemberShape)this.resourceStructure.getMember(propertyName).get();
        return "/properties/" + this.getJsonSchemaConverter().toPropertyName(member);
    }
}

