/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class CfnResourceTrait
extends AbstractTrait
implements ToSmithyBuilder<CfnResourceTrait> {
    public static final ShapeId ID = ShapeId.from((String)"aws.cloudformation#cfnResource");
    private final String name;
    private final List<ShapeId> additionalSchemas;
    private final String primaryIdentifier;

    private CfnResourceTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.name = builder.name;
        this.additionalSchemas = ListUtils.copyOf((Collection)builder.additionalSchemas);
        this.primaryIdentifier = builder.primaryIdentifier;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public List<ShapeId> getAdditionalSchemas() {
        return this.additionalSchemas;
    }

    public Optional<String> getPrimaryIdentifier() {
        return Optional.ofNullable(this.primaryIdentifier);
    }

    public static Builder builder() {
        return new Builder();
    }

    protected Node createNode() {
        NodeMapper mapper = new NodeMapper();
        mapper.disableToNodeForClass(CfnResourceTrait.class);
        mapper.setOmitEmptyValues(true);
        return mapper.serialize((Object)this).expectObjectNode();
    }

    public Builder toBuilder() {
        return ((Builder)CfnResourceTrait.builder().sourceLocation((FromSourceLocation)this.getSourceLocation())).name(this.name).additionalSchemas(this.additionalSchemas);
    }

    public static final class Builder
    extends AbstractTraitBuilder<CfnResourceTrait, Builder> {
        private String name;
        private final List<ShapeId> additionalSchemas = new ArrayList<ShapeId>();
        private String primaryIdentifier;

        private Builder() {
        }

        public CfnResourceTrait build() {
            return new CfnResourceTrait(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder addAdditionalSchema(ShapeId additionalSchema) {
            this.additionalSchemas.add(additionalSchema);
            return this;
        }

        public Builder additionalSchemas(List<ShapeId> additionalSchemas) {
            this.additionalSchemas.clear();
            this.additionalSchemas.addAll(additionalSchemas);
            return this;
        }

        public Builder primaryIdentifier(String primaryIdentifier) {
            this.primaryIdentifier = primaryIdentifier;
            return this;
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        public Trait createTrait(ShapeId target, Node value) {
            CfnResourceTrait result = (CfnResourceTrait)((Object)new NodeMapper().deserialize(value, CfnResourceTrait.class));
            result.setNodeCache(value);
            return result;
        }
    }
}

