/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.traits;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.aws.cloudformation.traits.CfnAdditionalIdentifierTrait;
import software.amazon.smithy.aws.cloudformation.traits.CfnMutabilityTrait;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class CfnMutabilityTraitValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (Shape shape : model.getShapesWithTrait(CfnMutabilityTrait.class)) {
            CfnMutabilityTrait trait = (CfnMutabilityTrait)shape.expectTrait(CfnMutabilityTrait.class);
            if (!shape.hasTrait(CfnAdditionalIdentifierTrait.ID) || !trait.isWrite() && !trait.isCreate()) continue;
            events.add(this.error(shape, (FromSourceLocation)trait, String.format("Member with the mutability value of \"%s\" is also marked as an additional identifier", trait.getValue())));
        }
        return events;
    }
}

