/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.apigateway.traits;

import java.util.Map;
import java.util.Optional;
import software.amazon.smithy.aws.apigateway.traits.IntegrationResponse;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class MockIntegrationTrait
extends AbstractTrait
implements ToSmithyBuilder<MockIntegrationTrait> {
    public static final ShapeId ID = ShapeId.from((String)"aws.apigateway#mockIntegration");
    private final String passThroughBehavior;
    private final String contentHandling;
    private final Map<String, String> requestParameters;
    private final Map<String, String> requestTemplates;
    private final Map<String, IntegrationResponse> responses;

    private MockIntegrationTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.passThroughBehavior = builder.passThroughBehavior;
        this.contentHandling = builder.contentHandling;
        this.requestParameters = (Map)builder.requestParameters.copy();
        this.requestTemplates = (Map)builder.requestTemplates.copy();
        this.responses = (Map)builder.responses.copy();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<String> getPassThroughBehavior() {
        return Optional.ofNullable(this.passThroughBehavior);
    }

    public Map<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    public Optional<String> getRequestParameter(String expression) {
        return Optional.ofNullable(this.requestParameters.get(expression));
    }

    public Map<String, String> getRequestTemplates() {
        return this.requestTemplates;
    }

    public Optional<String> getRequestTemplate(String mimeType) {
        return Optional.ofNullable(this.requestTemplates.get(mimeType));
    }

    public Map<String, IntegrationResponse> getResponses() {
        return this.responses;
    }

    public Optional<IntegrationResponse> getResponse(String statusCode) {
        return Optional.ofNullable(this.responses.get(statusCode));
    }

    public Optional<String> getContentHandling() {
        return Optional.ofNullable(this.contentHandling);
    }

    protected ObjectNode createNode() {
        NodeMapper mapper = new NodeMapper();
        mapper.disableToNodeForClass(MockIntegrationTrait.class);
        mapper.setOmitEmptyValues(true);
        return mapper.serialize((Object)this).expectObjectNode();
    }

    public Builder toBuilder() {
        return ((Builder)MockIntegrationTrait.builder().sourceLocation((FromSourceLocation)this.getSourceLocation())).passThroughBehavior(this.passThroughBehavior).contentHandling(this.contentHandling).requestParameters(this.requestParameters).requestTemplates(this.requestTemplates).responses(this.responses);
    }

    public static final class Builder
    extends AbstractTraitBuilder<MockIntegrationTrait, Builder> {
        private String passThroughBehavior;
        private String contentHandling;
        private final BuilderRef<Map<String, String>> requestParameters = BuilderRef.forOrderedMap();
        private final BuilderRef<Map<String, String>> requestTemplates = BuilderRef.forOrderedMap();
        private final BuilderRef<Map<String, IntegrationResponse>> responses = BuilderRef.forOrderedMap();

        public MockIntegrationTrait build() {
            return new MockIntegrationTrait(this);
        }

        public Builder passThroughBehavior(String passThroughBehavior) {
            this.passThroughBehavior = passThroughBehavior;
            return this;
        }

        public Builder contentHandling(String contentHandling) {
            this.contentHandling = contentHandling;
            return this;
        }

        public Builder putRequestParameter(String input, String output) {
            ((Map)this.requestParameters.get()).put(input, output);
            return this;
        }

        public Builder requestParameters(Map<String, String> requestParameters) {
            this.requestParameters.clear();
            requestParameters.forEach(this::putRequestParameter);
            return this;
        }

        public Builder removeRequestParameter(String expression) {
            ((Map)this.requestParameters.get()).remove(expression);
            return this;
        }

        public Builder putRequestTemplate(String mimeType, String template) {
            ((Map)this.requestTemplates.get()).put(mimeType, template);
            return this;
        }

        public Builder requestTemplates(Map<String, String> requestTemplates) {
            this.requestTemplates.clear();
            requestTemplates.forEach(this::putRequestTemplate);
            return this;
        }

        public Builder removeRequestTemplate(String mimeType) {
            ((Map)this.requestTemplates.get()).remove(mimeType);
            return this;
        }

        public Builder putResponse(String statusCodeRegex, IntegrationResponse integrationResponse) {
            ((Map)this.responses.get()).put(statusCodeRegex, integrationResponse);
            return this;
        }

        public Builder responses(Map<String, IntegrationResponse> responses) {
            this.responses.clear();
            responses.forEach(this::putResponse);
            return this;
        }

        public Builder removeResponse(String statusCodeRegex) {
            ((Map)this.responses.get()).remove(statusCodeRegex);
            return this;
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        public Trait createTrait(ShapeId target, Node value) {
            MockIntegrationTrait result = (MockIntegrationTrait)((Object)new NodeMapper().deserialize(value, MockIntegrationTrait.class));
            result.setNodeCache(value);
            return result;
        }
    }
}

