/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.apigateway.traits;

import java.util.Map;
import java.util.Optional;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class IntegrationResponse
implements ToNode,
ToSmithyBuilder<IntegrationResponse> {
    private final String statusCode;
    private final String contentHandling;
    private final Map<String, String> responseTemplates;
    private final Map<String, String> responseParameters;
    private final FromSourceLocation sourceLocation;

    private IntegrationResponse(Builder builder) {
        this.statusCode = (String)SmithyBuilder.requiredState((String)"statusCode", (Object)builder.statusCode);
        this.contentHandling = builder.contentHandling;
        this.responseTemplates = (Map)builder.responseTemplates.copy();
        this.responseParameters = (Map)builder.responseParameters.copy();
        this.sourceLocation = builder.sourceLocation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public Optional<String> getContentHandling() {
        return Optional.ofNullable(this.contentHandling);
    }

    public Map<String, String> getResponseTemplates() {
        return this.responseTemplates;
    }

    public Optional<String> getResponseTemplate(String mimeType) {
        return Optional.ofNullable(this.responseTemplates.get(mimeType));
    }

    public Map<String, String> getResponseParameters() {
        return this.responseParameters;
    }

    public Optional<String> getResponseParameter(String name) {
        return Optional.ofNullable(this.responseParameters.get(name));
    }

    public Builder toBuilder() {
        Builder builder = IntegrationResponse.builder();
        this.responseTemplates.forEach(builder::putResponseTemplate);
        this.responseParameters.forEach(builder::putResponseParameter);
        return builder.sourceLocation(this.sourceLocation).contentHandling(this.contentHandling).statusCode(this.statusCode);
    }

    public Node toNode() {
        NodeMapper mapper = new NodeMapper();
        mapper.disableToNodeForClass(IntegrationResponse.class);
        mapper.setOmitEmptyValues(true);
        return mapper.serialize((Object)this).expectObjectNode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntegrationResponse)) {
            return false;
        }
        IntegrationResponse other = (IntegrationResponse)o;
        return this.toNode().equals(other.toNode());
    }

    public int hashCode() {
        return this.toNode().hashCode();
    }

    public static final class Builder
    implements SmithyBuilder<IntegrationResponse> {
        private String statusCode;
        private String contentHandling;
        private final BuilderRef<Map<String, String>> responseTemplates = BuilderRef.forSortedMap();
        private final BuilderRef<Map<String, String>> responseParameters = BuilderRef.forSortedMap();
        private FromSourceLocation sourceLocation;

        public IntegrationResponse build() {
            return new IntegrationResponse(this);
        }

        public Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder contentHandling(String contentHandling) {
            this.contentHandling = contentHandling;
            return this;
        }

        public Builder responseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates.clear();
            responseTemplates.forEach(this::putResponseTemplate);
            return this;
        }

        public Builder putResponseTemplate(String mimeType, String template) {
            ((Map)this.responseTemplates.get()).put(mimeType, template);
            return this;
        }

        public Builder removeResponseTemplate(String mimeType) {
            ((Map)this.responseTemplates.get()).remove(mimeType);
            return this;
        }

        public Builder responseParameters(Map<String, String> responseParameters) {
            this.responseParameters.clear();
            responseParameters.forEach(this::putResponseParameter);
            return this;
        }

        public Builder putResponseParameter(String name, String value) {
            ((Map)this.responseParameters.get()).put(name, value);
            return this;
        }

        public Builder removeResponseParameter(String name) {
            ((Map)this.responseParameters.get()).remove(name);
            return this;
        }

        Builder sourceLocation(FromSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }
    }
}

