/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.apigateway.traits;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import software.amazon.smithy.aws.apigateway.traits.AuthorizerDefinition;
import software.amazon.smithy.aws.apigateway.traits.AuthorizerTrait;
import software.amazon.smithy.aws.apigateway.traits.AuthorizersTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.selector.PathFinder;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.StringTrait;

public final class AuthorizerIndex
implements KnowledgeIndex {
    private static final Selector SELECTOR = Selector.parse((String)"operation");
    private final Map<ShapeId, Map<ShapeId, String>> authorizers = new HashMap<ShapeId, Map<ShapeId, String>>();
    private final Map<ShapeId, AuthorizersTrait> authorizerTraits = new HashMap<ShapeId, AuthorizersTrait>();

    public AuthorizerIndex(Model model) {
        PathFinder finder = PathFinder.create((Model)model);
        model.shapes(ServiceShape.class).forEach(service -> {
            service.getTrait(AuthorizersTrait.class).ifPresent(trait -> this.authorizerTraits.put(service.getId(), (AuthorizersTrait)((Object)((Object)trait))));
            HashMap<ShapeId, String> serviceMap = new HashMap<ShapeId, String>();
            this.authorizers.put(service.getId(), serviceMap);
            service.getTrait(AuthorizerTrait.class).ifPresent(trait -> serviceMap.put(service.getId(), trait.getValue()));
            for (PathFinder.Path path : finder.search((ToShapeId)service, SELECTOR)) {
                String effectiveAuthorizer = null;
                for (Shape shape : path.getShapes()) {
                    if (!shape.isServiceShape() && !shape.isResourceShape() && !shape.isOperationShape() || (effectiveAuthorizer = AuthorizerIndex.getNullableAuthorizerValue(shape, effectiveAuthorizer)) == null) continue;
                    serviceMap.put(shape.getId(), effectiveAuthorizer);
                }
            }
        });
    }

    public static AuthorizerIndex of(Model model) {
        return (AuthorizerIndex)model.getKnowledge(AuthorizerIndex.class, AuthorizerIndex::new);
    }

    private static String getNullableAuthorizerValue(Shape shape, String previous) {
        return shape.getTrait(AuthorizerTrait.class).map(StringTrait::getValue).orElse(previous);
    }

    public Optional<String> getAuthorizer(ToShapeId service, ToShapeId shape) {
        return Optional.ofNullable(this.authorizers.get(service.toShapeId())).flatMap(mappings -> Optional.ofNullable((String)mappings.get(shape.toShapeId())));
    }

    public Optional<String> getAuthorizer(ToShapeId service) {
        return this.getAuthorizer(service, service);
    }

    public Optional<AuthorizerDefinition> getAuthorizerValue(ToShapeId service) {
        return this.getAuthorizerValue(service, service);
    }

    public Optional<AuthorizerDefinition> getAuthorizerValue(ToShapeId service, ToShapeId shape) {
        return this.getAuthorizer(service, shape).flatMap(name -> Optional.ofNullable(this.authorizerTraits.get(service.toShapeId())).flatMap(trait -> trait.getAuthorizer((String)name)));
    }
}

