/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.apigateway.traits;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class IntegrationResponse
implements ToNode,
ToSmithyBuilder<IntegrationResponse> {
    private final String statusCode;
    private final String contentHandling;
    private final Map<String, String> responseTemplates;
    private final Map<String, String> responseParameters;
    private final FromSourceLocation sourceLocation;

    private IntegrationResponse(Builder builder) {
        this.statusCode = (String)SmithyBuilder.requiredState((String)"statusCode", (Object)builder.statusCode);
        this.contentHandling = builder.contentHandling;
        this.responseTemplates = MapUtils.copyOf((Map)builder.responseTemplates);
        this.responseParameters = MapUtils.copyOf((Map)builder.responseParameters);
        this.sourceLocation = builder.sourceLocation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public Optional<String> getContentHandling() {
        return Optional.ofNullable(this.contentHandling);
    }

    public Map<String, String> getResponseTemplates() {
        return this.responseTemplates;
    }

    public Optional<String> getResponseTemplate(String mimeType) {
        return Optional.ofNullable(this.responseTemplates.get(mimeType));
    }

    public Map<String, String> getResponseParameters() {
        return this.responseParameters;
    }

    public Optional<String> getResponseParameter(String name) {
        return Optional.ofNullable(this.responseParameters.get(name));
    }

    public Builder toBuilder() {
        Builder builder = IntegrationResponse.builder();
        this.responseTemplates.forEach(builder::putResponseTemplate);
        this.responseParameters.forEach(builder::putResponseParameter);
        return builder.sourceLocation(this.sourceLocation).contentHandling(this.contentHandling).statusCode(this.statusCode);
    }

    public Node toNode() {
        NodeMapper mapper = new NodeMapper();
        mapper.disableToNodeForClass(IntegrationResponse.class);
        mapper.setOmitEmptyValues(true);
        return mapper.serialize((Object)this).expectObjectNode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntegrationResponse)) {
            return false;
        }
        IntegrationResponse other = (IntegrationResponse)o;
        return this.toNode().equals(other.toNode());
    }

    public int hashCode() {
        return this.toNode().hashCode();
    }

    public static final class Builder
    implements SmithyBuilder<IntegrationResponse> {
        private String statusCode;
        private String contentHandling;
        private Map<String, String> responseTemplates = new HashMap<String, String>();
        private Map<String, String> responseParameters = new HashMap<String, String>();
        private FromSourceLocation sourceLocation;

        public IntegrationResponse build() {
            return new IntegrationResponse(this);
        }

        public Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder contentHandling(String contentHandling) {
            this.contentHandling = contentHandling;
            return this;
        }

        public Builder responseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates.clear();
            this.responseTemplates.putAll(responseTemplates);
            return this;
        }

        public Builder putResponseTemplate(String mimeType, String template) {
            this.responseTemplates.put(mimeType, template);
            return this;
        }

        public Builder removeResponseTemplate(String mimeType) {
            this.responseTemplates.remove(mimeType);
            return this;
        }

        public Builder responseParameters(Map<String, String> responseParameters) {
            this.responseParameters.clear();
            this.responseParameters.putAll(responseParameters);
            return this;
        }

        public Builder putResponseParameter(String name, String value) {
            this.responseParameters.put(name, value);
            return this;
        }

        public Builder removeResponseParameter(String name) {
            this.responseParameters.remove(name);
            return this;
        }

        Builder sourceLocation(FromSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }
    }
}

