/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.apigateway.traits;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.aws.apigateway.traits.AuthorizerDefinition;
import software.amazon.smithy.aws.apigateway.traits.AuthorizersTrait;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.ServiceIndex;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class AuthorizersTraitValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        return model.shapes(ServiceShape.class).flatMap(service -> OptionalUtils.stream(this.validateService(model, (ServiceShape)service))).collect(Collectors.toList());
    }

    private Optional<ValidationEvent> validateService(Model model, ServiceShape service) {
        Set authSchemes = ServiceIndex.of((Model)model).getAuthSchemes((ToShapeId)service).keySet();
        String invalidMappings = service.getTrait(AuthorizersTrait.class).map(AuthorizersTrait::getAuthorizers).orElseGet(HashMap::new).entrySet().stream().filter(entry -> !authSchemes.contains(((AuthorizerDefinition)entry.getValue()).getScheme())).map(entry -> (String)entry.getKey() + " -> " + ((AuthorizerDefinition)entry.getValue()).getScheme()).sorted().collect(Collectors.joining(", "));
        if (invalidMappings.isEmpty()) {
            return Optional.empty();
        }
        AuthorizersTrait authorizersTrait = (AuthorizersTrait)((Object)service.getTrait(AuthorizersTrait.class).get());
        return Optional.of(this.error((Shape)service, (FromSourceLocation)authorizersTrait, String.format("Each `scheme` of the `%s` trait must target one of the auth schemes applied to the service (i.e., [%s]). The following mappings of authorizer names to schemes are invalid: %s", AuthorizersTrait.ID, ValidationUtils.tickedList(authSchemes), invalidMappings)));
    }
}

