/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.apigateway.traits;

import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.aws.traits.auth.SigV4Trait;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class AuthorizerDefinition
implements ToNode,
ToSmithyBuilder<AuthorizerDefinition> {
    private static final String SIGV4_AUTH_TYPE = "awsSigv4";
    private static final String SCHEME_KEY = "scheme";
    private final ShapeId scheme;
    private final String type;
    private final String customAuthType;
    private final String uri;
    private final String credentials;
    private final String identitySource;
    private final String identityValidationExpression;
    private final Integer resultTtlInSeconds;

    private AuthorizerDefinition(Builder builder) {
        this.scheme = (ShapeId)SmithyBuilder.requiredState((String)SCHEME_KEY, (Object)builder.scheme);
        this.type = builder.type;
        this.uri = builder.uri;
        this.credentials = builder.credentials;
        this.identitySource = builder.identitySource;
        this.identityValidationExpression = builder.identityValidationExpression;
        this.resultTtlInSeconds = builder.resultTtlInSeconds;
        this.customAuthType = builder.customAuthType != null ? builder.customAuthType : (this.scheme.equals((Object)SigV4Trait.ID) ? SIGV4_AUTH_TYPE : null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public ShapeId getScheme() {
        return this.scheme;
    }

    public Optional<String> getType() {
        return Optional.ofNullable(this.type);
    }

    public Optional<String> getUri() {
        return Optional.ofNullable(this.uri);
    }

    public Optional<String> getCustomAuthType() {
        return Optional.ofNullable(this.customAuthType);
    }

    public Optional<String> getCredentials() {
        return Optional.ofNullable(this.credentials);
    }

    public Optional<String> getIdentitySource() {
        return Optional.ofNullable(this.identitySource);
    }

    public Optional<String> getIdentityValidationExpression() {
        return Optional.ofNullable(this.identityValidationExpression);
    }

    public Optional<Integer> getResultTtlInSeconds() {
        return Optional.ofNullable(this.resultTtlInSeconds);
    }

    public Builder toBuilder() {
        return AuthorizerDefinition.builder().scheme(this.scheme).type(this.type).uri(this.uri).customAuthType(this.customAuthType).credentials(this.credentials).identitySource(this.identitySource).identityValidationExpression(this.identityValidationExpression).resultTtlInSeconds(this.resultTtlInSeconds);
    }

    public Node toNode() {
        NodeMapper mapper = new NodeMapper();
        mapper.disableToNodeForClass(AuthorizerDefinition.class);
        return mapper.serialize((Object)this).expectObjectNode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthorizerDefinition)) {
            return false;
        }
        AuthorizerDefinition that = (AuthorizerDefinition)o;
        return this.scheme.equals((Object)that.scheme) && Objects.equals(this.type, that.type) && Objects.equals(this.uri, that.uri) && Objects.equals(this.customAuthType, that.customAuthType) && Objects.equals(this.credentials, that.credentials) && Objects.equals(this.identitySource, that.identitySource) && Objects.equals(this.identityValidationExpression, that.identityValidationExpression) && Objects.equals(this.resultTtlInSeconds, that.resultTtlInSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.scheme, this.type, this.uri);
    }

    public static final class Builder
    implements SmithyBuilder<AuthorizerDefinition> {
        private ShapeId scheme;
        private String type;
        private String customAuthType;
        private String uri;
        private String credentials;
        private String identitySource;
        private String identityValidationExpression;
        private Integer resultTtlInSeconds;

        public AuthorizerDefinition build() {
            return new AuthorizerDefinition(this);
        }

        public Builder scheme(ShapeId scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder customAuthType(String customAuthType) {
            this.customAuthType = customAuthType;
            return this;
        }

        public Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder credentials(String credentials) {
            this.credentials = credentials;
            return this;
        }

        public Builder identitySource(String identitySource) {
            this.identitySource = identitySource;
            return this;
        }

        public Builder identityValidationExpression(String identityValidationExpression) {
            this.identityValidationExpression = identityValidationExpression;
            return this;
        }

        public Builder resultTtlInSeconds(Integer resultTtlInSeconds) {
            this.resultTtlInSeconds = resultTtlInSeconds;
            return this;
        }
    }
}

