/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.apigateway.traits;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.aws.apigateway.traits.AuthorizerDefinition;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class AuthorizersTrait
extends AbstractTrait
implements ToSmithyBuilder<AuthorizersTrait> {
    public static final ShapeId ID = ShapeId.from((String)"aws.apigateway#authorizers");
    private final Map<String, AuthorizerDefinition> authorizers;

    private AuthorizersTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.authorizers = MapUtils.copyOf((Map)builder.authorizers);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<AuthorizerDefinition> getAuthorizer(String name) {
        return Optional.ofNullable(this.authorizers.get(name));
    }

    public Map<String, AuthorizerDefinition> getAuthorizers() {
        return this.authorizers;
    }

    public Builder toBuilder() {
        return ((Builder)AuthorizersTrait.builder().sourceLocation((FromSourceLocation)this.getSourceLocation())).authorizers(this.authorizers);
    }

    protected Node createNode() {
        return ((ObjectNode)this.authorizers.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue))).toBuilder().sourceLocation(this.getSourceLocation()).build();
    }

    public static final class Builder
    extends AbstractTraitBuilder<AuthorizersTrait, Builder> {
        private final Map<String, AuthorizerDefinition> authorizers = new HashMap<String, AuthorizerDefinition>();

        public AuthorizersTrait build() {
            return new AuthorizersTrait(this);
        }

        public Builder putAuthorizer(String name, AuthorizerDefinition authorizer) {
            this.authorizers.put(name, Objects.requireNonNull(authorizer));
            return this;
        }

        public Builder authorizers(Map<String, AuthorizerDefinition> authorizers) {
            this.clearAuthorizers();
            authorizers.forEach(this::putAuthorizer);
            return this;
        }

        public Builder removeAuthorizer(String name) {
            this.authorizers.remove(name);
            return this;
        }

        public Builder clearAuthorizers() {
            this.authorizers.clear();
            return this;
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        public Trait createTrait(ShapeId target, Node value) {
            NodeMapper mapper = new NodeMapper();
            Builder builder = (Builder)AuthorizersTrait.builder().sourceLocation((FromSourceLocation)value);
            value.expectObjectNode().getMembers().forEach((key, node) -> {
                AuthorizerDefinition authorizer = (AuthorizerDefinition)mapper.deserialize(node, AuthorizerDefinition.class);
                builder.putAuthorizer(key.getValue(), authorizer);
            });
            return builder.build();
        }
    }
}

