/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.apigateway.openapi;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import software.amazon.smithy.aws.apigateway.openapi.ApiGatewayConfig;
import software.amazon.smithy.aws.apigateway.openapi.ApiGatewayMapper;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeVisitor;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.model.OpenApi;
import software.amazon.smithy.utils.ListUtils;

final class CloudFormationSubstitution
implements ApiGatewayMapper {
    private static final Logger LOGGER = Logger.getLogger(CloudFormationSubstitution.class.getName());
    private static final String SUBSTITUTION_KEY = "Fn::Sub";
    private static final Pattern SUBSTITUTION_PATTERN = Pattern.compile("\\$\\{.+}");
    private static final List<String> PATHS = Arrays.asList("components/securitySchemes/*/x-amazon-apigateway-authorizer/providerARNs/*", "components/securitySchemes/*/x-amazon-apigateway-authorizer/authorizerCredentials", "components/securitySchemes/*/x-amazon-apigateway-authorizer/authorizerUri", "paths/*/*/x-amazon-apigateway-integration/connectionId", "paths/*/*/x-amazon-apigateway-integration/credentials", "paths/*/*/x-amazon-apigateway-integration/uri");

    CloudFormationSubstitution() {
    }

    @Override
    public List<ApiGatewayConfig.ApiType> getApiTypes() {
        return ListUtils.of((Object[])new ApiGatewayConfig.ApiType[]{ApiGatewayConfig.ApiType.REST, ApiGatewayConfig.ApiType.HTTP});
    }

    public byte getOrder() {
        return 127;
    }

    public ObjectNode updateNode(Context<? extends Trait> context, OpenApi openapi, ObjectNode node) {
        if (!((ApiGatewayConfig)context.getConfig().getExtensions(ApiGatewayConfig.class)).getDisableCloudFormationSubstitution()) {
            return ((Node)node.accept((NodeVisitor)new CloudFormationFnSubInjector(PATHS))).expectObjectNode();
        }
        return node;
    }

    private static class CloudFormationFnSubInjector
    extends NodeVisitor.Default<Node> {
        private final Deque<String> stack = new ArrayDeque<String>();
        private final List<String[]> paths;

        CloudFormationFnSubInjector(List<String> paths) {
            this.paths = paths.stream().map(path -> path.split(Pattern.quote("/"))).collect(Collectors.toList());
        }

        protected Node getDefault(Node node) {
            return node;
        }

        public Node arrayNode(ArrayNode node) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (int i = 0; i < node.size(); ++i) {
                Node member = (Node)node.get(i).get();
                this.stack.addLast(String.valueOf(i));
                result.add(member.accept((NodeVisitor)this));
                this.stack.removeLast();
            }
            return new ArrayNode(result, SourceLocation.NONE);
        }

        public Node objectNode(ObjectNode node) {
            LinkedHashMap result = new LinkedHashMap();
            for (Map.Entry entry : node.getMembers().entrySet()) {
                this.stack.addLast(((StringNode)entry.getKey()).getValue());
                result.put(entry.getKey(), ((Node)entry.getValue()).accept((NodeVisitor)this));
                this.stack.removeLast();
            }
            return new ObjectNode(result, SourceLocation.NONE);
        }

        public Node stringNode(StringNode node) {
            if (SUBSTITUTION_PATTERN.matcher(node.getValue()).find() && this.isInPath()) {
                LOGGER.fine(() -> String.format("Detected CloudFormation variable syntax in %s; replacing with a `Fn::Sub` CloudFormation intrinsic function block", node.getValue()));
                return Node.objectNode().withMember(CloudFormationSubstitution.SUBSTITUTION_KEY, (ToNode)node);
            }
            return node;
        }

        private boolean isInPath() {
            return this.paths.stream().anyMatch(this::matchesPath);
        }

        private boolean matchesPath(String[] path) {
            Iterator<String> iterator = this.stack.iterator();
            for (String segment : path) {
                if (!iterator.hasNext()) {
                    return false;
                }
                String current = iterator.next();
                if (segment.equals(current) || segment.equals("*")) continue;
                return false;
            }
            return true;
        }
    }
}

