/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.apigateway.openapi;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import software.amazon.smithy.aws.apigateway.openapi.ApiGatewayConfig;
import software.amazon.smithy.aws.apigateway.openapi.ApiGatewayMapper;
import software.amazon.smithy.aws.apigateway.openapi.CorsHeader;
import software.amazon.smithy.aws.apigateway.traits.IntegrationTrait;
import software.amazon.smithy.aws.apigateway.traits.IntegrationTraitIndex;
import software.amazon.smithy.aws.apigateway.traits.MockIntegrationTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.CorsTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.openapi.OpenApiException;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.model.OperationObject;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.Pair;

final class AddIntegrations
implements ApiGatewayMapper {
    private static final Logger LOGGER = Logger.getLogger(AddIntegrations.class.getName());
    private static final String EXTENSION_NAME = "x-amazon-apigateway-integration";
    private static final String RESPONSES_KEY = "responses";
    private static final String HEADER_PREFIX = "method.response.header.";
    private static final String DEFAULT_KEY = "default";
    private static final String STATUS_CODE_KEY = "statusCode";
    private static final String RESPONSE_PARAMETERS_KEY = "responseParameters";
    private static final String PASSTHROUGH_BEHAVIOR = "passthroughBehavior";
    private static final String INCORRECT_PASSTHROUGH_BEHAVIOR = "passThroughBehavior";

    AddIntegrations() {
    }

    @Override
    public List<ApiGatewayConfig.ApiType> getApiTypes() {
        return ListUtils.of((Object[])new ApiGatewayConfig.ApiType[]{ApiGatewayConfig.ApiType.REST, ApiGatewayConfig.ApiType.HTTP});
    }

    public OperationObject updateOperation(Context<? extends Trait> context, OperationShape shape, OperationObject operation, String httpMethod, String path) {
        IntegrationTraitIndex index = IntegrationTraitIndex.of((Model)context.getModel());
        return index.getIntegrationTrait((ToShapeId)context.getService(), (ToShapeId)shape).map(trait -> ((OperationObject.Builder)operation.toBuilder().putExtension(EXTENSION_NAME, (Node)this.createIntegration(context, operation, shape, (Trait)trait))).build()).orElseGet(() -> {
            LOGGER.warning("No API Gateway integration trait found for " + shape.getId());
            return operation;
        });
    }

    private ObjectNode createIntegration(Context<? extends Trait> context, OperationObject operationObject, OperationShape shape, Trait integration) {
        ObjectNode integrationObject = AddIntegrations.getIntegrationAsObject(context, shape, integration);
        return context.getService().getTrait(CorsTrait.class).map(cors -> {
            LOGGER.fine(() -> String.format("Adding CORS to `%s` operation responses", shape.getId()));
            return this.updateIntegrationWithCors(context, operationObject, shape, integrationObject, (CorsTrait)cors);
        }).orElse(integrationObject);
    }

    private static ObjectNode getIntegrationAsObject(Context<? extends Trait> context, OperationShape shape, Trait integration) {
        ObjectNode integrationNode;
        if (integration instanceof MockIntegrationTrait) {
            integrationNode = integration.toNode().expectObjectNode().withMember("type", (ToNode)Node.from((String)"mock"));
        } else if (integration instanceof IntegrationTrait) {
            integrationNode = ((IntegrationTrait)integration).toExpandedNode((ToShapeId)context.getService(), (ToShapeId)shape);
        } else {
            throw new OpenApiException("Unexpected integration trait: " + integration);
        }
        Optional passthroughBehavior = integrationNode.getMember(INCORRECT_PASSTHROUGH_BEHAVIOR);
        if (passthroughBehavior.isPresent()) {
            integrationNode = integrationNode.withoutMember(INCORRECT_PASSTHROUGH_BEHAVIOR).withMember(PASSTHROUGH_BEHAVIOR, (ToNode)((Node)passthroughBehavior.get()));
        }
        return integrationNode;
    }

    private ObjectNode updateIntegrationWithCors(Context<? extends Trait> context, OperationObject operationObject, OperationShape shape, ObjectNode integrationNode, CorsTrait cors) {
        ObjectNode responses = integrationNode.getObjectMember(RESPONSES_KEY).orElse(Node.objectNode());
        if (!responses.getMember(DEFAULT_KEY).isPresent()) {
            responses = responses.withMember(DEFAULT_KEY, (ToNode)Node.objectNode().withMember(STATUS_CODE_KEY, "200"));
        }
        HashMap<CorsHeader, String> corsHeaders = new HashMap<CorsHeader, String>();
        corsHeaders.put(CorsHeader.ALLOW_ORIGIN, cors.getOrigin());
        if (context.usesHttpCredentials()) {
            corsHeaders.put(CorsHeader.ALLOW_CREDENTIALS, "true");
        }
        LOGGER.finer(() -> String.format("Adding the following CORS headers to the API Gateway integration of %s: %s", shape.getId(), corsHeaders));
        Set<String> deducedHeaders = CorsHeader.deduceOperationResponseHeaders(context, operationObject, shape, cors);
        LOGGER.fine(() -> String.format("Detected the following headers for operation %s: %s", shape.getId(), deducedHeaders));
        responses = (ObjectNode)responses.getMembers().entrySet().stream().peek(entry -> LOGGER.fine(() -> String.format("Updating integration response %s for `%s` with CORS", entry.getKey(), shape.getId()))).map(entry -> Pair.of((Object)((StringNode)entry.getKey()), (Object)this.updateIntegrationResponse(shape, corsHeaders, deducedHeaders, ((Node)entry.getValue()).expectObjectNode()))).collect(ObjectNode.collect(Pair::getLeft, Pair::getRight));
        return integrationNode.withMember(RESPONSES_KEY, (ToNode)responses);
    }

    private ObjectNode updateIntegrationResponse(OperationShape shape, Map<CorsHeader, String> corsHeaders, Set<String> deduced, ObjectNode response) {
        HashMap<CorsHeader, String> responseHeaders = new HashMap<CorsHeader, String>(corsHeaders);
        ObjectNode responseParams = response.getObjectMember(RESPONSE_PARAMETERS_KEY).orElseGet(Node::objectNode);
        TreeSet<String> headersToExpose = new TreeSet<String>(deduced);
        responseParams.getStringMap().keySet().stream().filter(parameterName -> parameterName.startsWith(HEADER_PREFIX)).map(parameterName -> parameterName.substring(HEADER_PREFIX.length())).forEach(headersToExpose::add);
        String headersToExposeString = String.join((CharSequence)",", headersToExpose);
        if (!headersToExposeString.isEmpty()) {
            responseHeaders.put(CorsHeader.EXPOSE_HEADERS, headersToExposeString);
            LOGGER.fine(() -> String.format("Adding `%s` header to `%s` with value of `%s`", new Object[]{CorsHeader.EXPOSE_HEADERS, shape.getId(), headersToExposeString}));
        }
        if (responseHeaders.isEmpty()) {
            LOGGER.fine(() -> "No headers are exposed by " + shape.getId());
            return response;
        }
        ObjectNode.Builder builder = responseParams.toBuilder();
        for (Map.Entry entry : responseHeaders.entrySet()) {
            builder.withMember(HEADER_PREFIX + entry.getKey(), "'" + (String)entry.getValue() + "'");
        }
        return response.withMember(RESPONSE_PARAMETERS_KEY, (ToNode)builder.build());
    }
}

