/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.apigateway.openapi;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.aws.apigateway.openapi.ApiGatewayConfig;
import software.amazon.smithy.aws.apigateway.openapi.ApiGatewayMapper;
import software.amazon.smithy.aws.apigateway.traits.RequestValidatorTrait;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.traits.StringTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.model.OpenApi;
import software.amazon.smithy.openapi.model.OperationObject;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.OptionalUtils;

final class AddRequestValidators
implements ApiGatewayMapper {
    private static final String REQUEST_VALIDATOR = "x-amazon-apigateway-request-validator";
    private static final String REQUEST_VALIDATORS = "x-amazon-apigateway-request-validators";
    private static final Map<String, Node> KNOWN_VALIDATORS = MapUtils.of((Object)"params-only", (Object)Node.objectNode().withMember("validateRequestParameters", (ToNode)Node.from((boolean)true)), (Object)"body-only", (Object)Node.objectNode().withMember("validateRequestBody", (ToNode)Node.from((boolean)true)), (Object)"full", (Object)Node.objectNode().withMember("validateRequestParameters", (ToNode)Node.from((boolean)true)).withMember("validateRequestBody", (ToNode)Node.from((boolean)true)));

    AddRequestValidators() {
    }

    @Override
    public List<ApiGatewayConfig.ApiType> getApiTypes() {
        return ListUtils.of((Object)((Object)ApiGatewayConfig.ApiType.REST), (Object)((Object)ApiGatewayConfig.ApiType.HTTP));
    }

    public OperationObject updateOperation(Context<? extends Trait> context, OperationShape shape, OperationObject operation, String httpMethod, String path) {
        return shape.getTrait(RequestValidatorTrait.class).map(StringTrait::getValue).map(value -> ((OperationObject.Builder)operation.toBuilder().putExtension(REQUEST_VALIDATOR, value)).build()).orElse(operation);
    }

    public OpenApi after(Context<? extends Trait> context, OpenApi openapi) {
        Set validators = context.getModel().shapes(OperationShape.class).flatMap(shape -> OptionalUtils.stream((Optional)shape.getTrait(RequestValidatorTrait.class))).map(StringTrait::getValue).filter(KNOWN_VALIDATORS::containsKey).collect(Collectors.toSet());
        String serviceValidator = null;
        if (context.getService().getTrait(RequestValidatorTrait.class).isPresent()) {
            serviceValidator = ((RequestValidatorTrait)context.getService().getTrait(RequestValidatorTrait.class).get()).getValue();
            validators.add(serviceValidator);
        }
        if (validators.isEmpty()) {
            return openapi;
        }
        OpenApi.Builder builder = openapi.toBuilder();
        if (serviceValidator != null) {
            builder.putExtension(REQUEST_VALIDATOR, serviceValidator);
        }
        ObjectNode.Builder objectBuilder = Node.objectNodeBuilder();
        for (String validator : validators) {
            objectBuilder.withMember(validator, (ToNode)KNOWN_VALIDATORS.get(validator));
        }
        builder.putExtension(REQUEST_VALIDATORS, (Node)objectBuilder.build());
        return builder.build();
    }
}

