/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.apigateway.openapi;

import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import software.amazon.smithy.aws.apigateway.openapi.ApiGatewayConfig;
import software.amazon.smithy.aws.apigateway.openapi.ApiGatewayMapper;
import software.amazon.smithy.aws.apigateway.traits.IntegrationTrait;
import software.amazon.smithy.aws.apigateway.traits.IntegrationTraitIndex;
import software.amazon.smithy.aws.apigateway.traits.MockIntegrationTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.openapi.OpenApiException;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.model.OperationObject;
import software.amazon.smithy.utils.ListUtils;

final class AddIntegrations
implements ApiGatewayMapper {
    static final String INTEGRATION_EXTENSION_NAME = "x-amazon-apigateway-integration";
    private static final Logger LOGGER = Logger.getLogger(AddIntegrations.class.getName());
    private static final String PASSTHROUGH_BEHAVIOR = "passthroughBehavior";
    private static final String INCORRECT_PASSTHROUGH_BEHAVIOR = "passThroughBehavior";

    AddIntegrations() {
    }

    @Override
    public List<ApiGatewayConfig.ApiType> getApiTypes() {
        return ListUtils.of((Object)((Object)ApiGatewayConfig.ApiType.REST), (Object)((Object)ApiGatewayConfig.ApiType.HTTP));
    }

    public OperationObject updateOperation(Context<? extends Trait> context, OperationShape shape, OperationObject operation, String httpMethod, String path) {
        IntegrationTraitIndex index = IntegrationTraitIndex.of((Model)context.getModel());
        return index.getIntegrationTrait((ToShapeId)context.getService(), (ToShapeId)shape).map(trait -> ((OperationObject.Builder)operation.toBuilder().putExtension(INTEGRATION_EXTENSION_NAME, (Node)AddIntegrations.createIntegration(context, shape, trait))).build()).orElseGet(() -> {
            LOGGER.warning("No API Gateway integration trait found for " + shape.getId());
            return operation;
        });
    }

    static ObjectNode createIntegration(MockIntegrationTrait integration) {
        return AddIntegrations.createIntegration(null, null, (Trait)integration);
    }

    private static ObjectNode createIntegration(Context<? extends Trait> context, OperationShape shape, Trait integration) {
        ObjectNode integrationNode;
        if (integration instanceof MockIntegrationTrait) {
            integrationNode = integration.toNode().expectObjectNode().withMember("type", (ToNode)Node.from((String)"mock"));
        } else if (integration instanceof IntegrationTrait) {
            AddIntegrations.validateTraitConfiguration((IntegrationTrait)integration, context, shape);
            integrationNode = ((IntegrationTrait)integration).toExpandedNode((ToShapeId)context.getService(), (ToShapeId)shape);
        } else {
            throw new OpenApiException("Unexpected integration trait: " + integration);
        }
        Optional passthroughBehavior = integrationNode.getMember(INCORRECT_PASSTHROUGH_BEHAVIOR);
        if (passthroughBehavior.isPresent()) {
            integrationNode = integrationNode.withoutMember(INCORRECT_PASSTHROUGH_BEHAVIOR).withMember(PASSTHROUGH_BEHAVIOR, (ToNode)passthroughBehavior.get());
        }
        return integrationNode;
    }

    private static void validateTraitConfiguration(IntegrationTrait trait, Context<? extends Trait> context, OperationShape operation) {
        ApiGatewayConfig.ApiType apiType = ((ApiGatewayConfig)context.getConfig().getExtensions(ApiGatewayConfig.class)).getApiGatewayType();
        if (!trait.getPayloadFormatVersion().isPresent() && apiType.equals((Object)ApiGatewayConfig.ApiType.HTTP)) {
            throw new OpenApiException("When the 'apiGatewayType' OpenAPI conversion setting is 'HTTP', a 'payloadFormatVersion' must be set on the aws.apigateway#integration trait.");
        }
    }
}

