/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.apigateway.openapi;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import software.amazon.smithy.aws.apigateway.openapi.ApiGatewayConfig;
import software.amazon.smithy.aws.apigateway.openapi.ApiGatewayMapper;
import software.amazon.smithy.aws.apigateway.openapi.CorsHeader;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.traits.CorsTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.model.ParameterObject;
import software.amazon.smithy.openapi.model.Ref;
import software.amazon.smithy.openapi.model.ResponseObject;
import software.amazon.smithy.utils.ListUtils;

final class AddCorsResponseHeaders
implements ApiGatewayMapper {
    private static final Logger LOGGER = Logger.getLogger(AddCorsResponseHeaders.class.getName());

    AddCorsResponseHeaders() {
    }

    @Override
    public List<ApiGatewayConfig.ApiType> getApiTypes() {
        return ListUtils.of((Object)((Object)ApiGatewayConfig.ApiType.REST));
    }

    public ResponseObject updateResponse(Context<? extends Trait> context, OperationShape shape, String status, String method, String path, ResponseObject response) {
        return context.getService().getTrait(CorsTrait.class).map(corsTrait -> this.addCorsHeadersToResponse(context, shape, response, (CorsTrait)corsTrait, method)).orElse(response);
    }

    private ResponseObject addCorsHeadersToResponse(Context<? extends Trait> context, OperationShape operation, ResponseObject response, CorsTrait corsTrait, String method) {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(CorsHeader.ALLOW_ORIGIN.toString());
        if (!method.equalsIgnoreCase("options")) {
            if (!CorsHeader.deduceOperationHeaders(context, operation, corsTrait).isEmpty()) {
                headers.add(CorsHeader.EXPOSE_HEADERS.toString());
            }
            if (context.usesHttpCredentials()) {
                headers.add(CorsHeader.ALLOW_CREDENTIALS.toString());
            }
        }
        LOGGER.finer(() -> String.format("Adding CORS headers to `%s` response: %s", operation.getId(), headers));
        ResponseObject.Builder builder = response.toBuilder();
        Schema headerSchema = Schema.builder().type("string").build();
        for (String headerName : headers) {
            if (response.getHeader(headerName).isPresent()) continue;
            ParameterObject headerParam = ParameterObject.builder().schema(headerSchema).build();
            builder.putHeader(headerName, Ref.local((ToNode)headerParam));
        }
        return builder.build();
    }
}

