/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.apigateway.openapi;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import software.amazon.smithy.aws.apigateway.openapi.AddApiKeySource;
import software.amazon.smithy.aws.traits.apigateway.AuthorizerDefinition;
import software.amazon.smithy.aws.traits.apigateway.AuthorizerIndex;
import software.amazon.smithy.aws.traits.apigateway.AuthorizersTrait;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.fromsmithy.OpenApiMapper;
import software.amazon.smithy.openapi.fromsmithy.SecuritySchemeConverter;
import software.amazon.smithy.openapi.model.ComponentsObject;
import software.amazon.smithy.openapi.model.OpenApi;
import software.amazon.smithy.openapi.model.OperationObject;
import software.amazon.smithy.openapi.model.SecurityScheme;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.MapUtils;

final class AddAuthorizers
implements OpenApiMapper {
    private static final String EXTENSION_NAME = "x-amazon-apigateway-authorizer";
    private static final String CLIENT_EXTENSION_NAME = "x-amazon-apigateway-authtype";
    private static final Logger LOGGER = Logger.getLogger(AddApiKeySource.class.getName());

    AddAuthorizers() {
    }

    public Map<String, List<String>> updateSecurity(Context context, Shape shape, SecuritySchemeConverter converter, Map<String, List<String>> requirement) {
        if (requirement.size() != 1 || !requirement.keySet().iterator().next().equals(converter.getAuthSchemeName())) {
            return requirement;
        }
        ServiceShape service = context.getService();
        AuthorizerIndex authorizerIndex = (AuthorizerIndex)context.getModel().getKnowledge(AuthorizerIndex.class);
        return authorizerIndex.getAuthorizer((ToShapeId)service, (ToShapeId)shape).map(authorizer -> MapUtils.of((Object)authorizer, (Object)((List)requirement.values().iterator().next()))).orElse(requirement);
    }

    public OperationObject updateOperation(Context context, OperationShape shape, OperationObject operation) {
        ServiceShape service = context.getService();
        AuthorizerIndex authorizerIndex = (AuthorizerIndex)context.getModel().getKnowledge(AuthorizerIndex.class);
        String serviceAuth = authorizerIndex.getAuthorizer((ToShapeId)service).orElse(null);
        String operationAuth = authorizerIndex.getAuthorizer((ToShapeId)service, (ToShapeId)shape).orElse(null);
        if (operationAuth == null || Objects.equals(operationAuth, serviceAuth)) {
            return operation;
        }
        return operation.toBuilder().addSecurity(MapUtils.of((Object)operationAuth, (Object)ListUtils.of())).build();
    }

    public OpenApi after(Context context, OpenApi openapi) {
        return context.getService().getTrait(AuthorizersTrait.class).map(authorizers -> this.addComputedAuthorizers(context, openapi, (AuthorizersTrait)authorizers)).orElse(openapi);
    }

    private OpenApi addComputedAuthorizers(Context context, OpenApi openApi, AuthorizersTrait trait) {
        OpenApi.Builder builder = openApi.toBuilder();
        ComponentsObject.Builder components = openApi.getComponents().toBuilder();
        block0: for (Map.Entry entry : trait.getAllAuthorizers().entrySet()) {
            String scheme = ((AuthorizerDefinition)entry.getValue()).getScheme();
            for (SecuritySchemeConverter converter : context.getSecuritySchemeConverters()) {
                AuthorizerDefinition authorizer = (AuthorizerDefinition)entry.getValue();
                if (!converter.getAuthSchemeName().equals(scheme)) continue;
                SecurityScheme createdScheme = converter.createSecurityScheme(context);
                SecurityScheme.Builder schemeBuilder = createdScheme.toBuilder();
                schemeBuilder.putExtension(CLIENT_EXTENSION_NAME, authorizer.getAuthType());
                ObjectNode authorizerNode = Node.objectNodeBuilder().withOptionalMember("type", authorizer.getType().map(Node::from)).withOptionalMember("authorizerUri", authorizer.getUri().map(Node::from)).withOptionalMember("authorizerCredentials", authorizer.getCredentials().map(Node::from)).withOptionalMember("identityValidationExpression", authorizer.getIdentityValidationExpression().map(Node::from)).withOptionalMember("identitySource", authorizer.getIdentitySource().map(Node::from)).withOptionalMember("authorizerResultTtlInSeconds", authorizer.getResultTtlInSeconds().map(Node::from)).build();
                if (authorizerNode.size() != 0) {
                    schemeBuilder.putExtension(EXTENSION_NAME, (Node)authorizerNode);
                }
                LOGGER.fine(() -> String.format("Adding the `%s` OpenAPI security scheme", entry.getKey()));
                components.putSecurityScheme((String)entry.getKey(), schemeBuilder.build());
                continue block0;
            }
        }
        builder.components(components.build());
        return builder.build();
    }
}

