/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.apigateway.openapi;

import java.util.logging.Logger;
import software.amazon.smithy.aws.traits.apigateway.ApiKeySourceTrait;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.fromsmithy.OpenApiMapper;
import software.amazon.smithy.openapi.model.OpenApi;

final class AddApiKeySource
implements OpenApiMapper {
    private static final String EXTENSION_NAME = "x-amazon-apigateway-api-key-source";
    private static final Logger LOGGER = Logger.getLogger(AddApiKeySource.class.getName());

    AddApiKeySource() {
    }

    public OpenApi after(Context context, OpenApi openApi) {
        return context.getService().getTrait(ApiKeySourceTrait.class).map(trait -> {
            LOGGER.fine(() -> String.format("Adding %s trait to %s", EXTENSION_NAME, context.getService().getId()));
            return ((OpenApi.Builder)openApi.toBuilder().putExtension(EXTENSION_NAME, trait.getValue())).build();
        }).orElse(openApi);
    }
}

