/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.apigateway.openapi;

import java.util.ArrayList;
import java.util.logging.Logger;
import software.amazon.smithy.aws.apigateway.openapi.CorsHeader;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.traits.CorsTrait;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.fromsmithy.OpenApiMapper;
import software.amazon.smithy.openapi.model.ParameterObject;
import software.amazon.smithy.openapi.model.Ref;
import software.amazon.smithy.openapi.model.ResponseObject;

final class AddCorsResponseHeaders
implements OpenApiMapper {
    private static final Logger LOGGER = Logger.getLogger(AddCorsResponseHeaders.class.getName());

    AddCorsResponseHeaders() {
    }

    public ResponseObject updateResponse(Context context, String status, OperationShape shape, ResponseObject response) {
        return context.getService().getTrait(CorsTrait.class).map(corsTrait -> this.addCorsHeadersToResponse(context, shape, response, (CorsTrait)corsTrait)).orElse(response);
    }

    private ResponseObject addCorsHeadersToResponse(Context context, OperationShape operation, ResponseObject response, CorsTrait corsTrait) {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(CorsHeader.ALLOW_ORIGIN.toString());
        if (!CorsHeader.deduceOperationHeaders(context, operation, corsTrait).isEmpty()) {
            headers.add(CorsHeader.EXPOSE_HEADERS.toString());
        }
        if (context.usesHttpCredentials()) {
            headers.add(CorsHeader.ALLOW_CREDENTIALS.toString());
        }
        LOGGER.finer(() -> String.format("Adding CORS headers to `%s` response: %s", operation.getId(), headers));
        ResponseObject.Builder builder = response.toBuilder();
        Schema headerSchema = Schema.builder().type("string").build();
        for (String headerName : headers) {
            if (response.getHeader(headerName).isPresent()) continue;
            ParameterObject headerParam = ParameterObject.builder().schema(headerSchema).build();
            builder.putHeader(headerName, Ref.local((ToNode)headerParam));
        }
        return builder.build();
    }
}

