/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.protocol.railsjson.generators;

import java.util.Optional;
import java.util.stream.Stream;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.HttpHeaderTrait;
import software.amazon.smithy.model.traits.HttpPrefixHeadersTrait;
import software.amazon.smithy.model.traits.HttpQueryParamsTrait;
import software.amazon.smithy.model.traits.HttpQueryTrait;
import software.amazon.smithy.model.traits.HttpResponseCodeTrait;
import software.amazon.smithy.model.traits.JsonNameTrait;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.generators.HttpParserGeneratorBase;
import software.amazon.smithy.ruby.codegen.trait.NoSerializeTrait;

public class ParserGenerator
extends HttpParserGeneratorBase {
    public ParserGenerator(GenerationContext context) {
        super(context);
    }

    protected void renderNoPayloadBodyParser(Shape outputShape) {
        this.writer.write((Object)"map = Seahorse::JSON.load(http_resp.body)", new Object[0]);
        this.renderMemberParsers(outputShape);
    }

    protected void renderStructureMemberParsers(StructureShape s) {
        this.renderMemberParsers((Shape)s);
    }

    protected String unionMemberDataName(UnionShape s, MemberShape member) {
        String dataName;
        String jsonName = dataName = RubyFormatter.toSnakeCase((String)this.symbolProvider.toMemberName(member));
        if (member.hasTrait(JsonNameTrait.class)) {
            jsonName = ((JsonNameTrait)member.getTrait(JsonNameTrait.class).get()).getValue();
        }
        return jsonName;
    }

    protected void renderUnionMemberParser(UnionShape s, MemberShape member) {
        Shape target = this.model.expectShape(member.getTarget());
        target.accept((ShapeVisitor)new MemberDeserializer(member, "value = ", "value"));
    }

    protected void renderMapMemberParser(MapShape s) {
        Shape valueTarget = this.model.expectShape(s.getValue().getTarget());
        valueTarget.accept((ShapeVisitor)new MemberDeserializer(s.getValue(), "data[key] = ", "value"));
    }

    protected void renderListMemberParser(ListShape s) {
        Shape memberTarget = this.model.expectShape(s.getMember().getTarget());
        memberTarget.accept((ShapeVisitor)new MemberDeserializer(s.getMember(), "", "value"));
    }

    protected void renderSetMemberParser(SetShape s) {
        Shape memberTarget = this.model.expectShape(s.getMember().getTarget());
        memberTarget.accept((ShapeVisitor)new MemberDeserializer(s.getMember(), "", "value"));
    }

    protected void renderPayloadBodyParser(Shape outputShape, MemberShape payloadMember, Shape target) {
        String dataName = this.symbolProvider.toMemberName(payloadMember);
        String dataSetter = "data." + dataName + " = ";
        target.accept((ShapeVisitor)new PayloadMemberDeserializer(payloadMember, dataSetter));
    }

    private void renderMemberParsers(Shape s) {
        Stream<MemberShape> parseMembers = s.members().stream().filter(m -> !m.hasTrait(HttpHeaderTrait.class) && !m.hasTrait(HttpPrefixHeadersTrait.class) && !m.hasTrait(HttpQueryTrait.class) && !m.hasTrait(HttpQueryParamsTrait.class) && !m.hasTrait(HttpResponseCodeTrait.class));
        parseMembers = parseMembers.filter(NoSerializeTrait.excludeNoSerializeMembers());
        parseMembers.forEach(member -> {
            Shape target = this.model.expectShape(member.getTarget());
            String dataName = this.symbolProvider.toMemberName(member);
            String dataSetter = "data." + dataName + " = ";
            String jsonName = RubyFormatter.toSnakeCase((String)member.getMemberName());
            if (member.hasTrait(JsonNameTrait.class)) {
                jsonName = ((JsonNameTrait)member.getTrait(JsonNameTrait.class).get()).getValue();
            }
            String valueGetter = "map['" + jsonName + "']";
            target.accept((ShapeVisitor)new MemberDeserializer((MemberShape)member, dataSetter, valueGetter));
        });
    }

    private class PayloadMemberDeserializer
    extends ShapeVisitor.Default<Void> {
        private final MemberShape memberShape;
        private final String dataSetter;

        PayloadMemberDeserializer(MemberShape memberShape, String dataSetter) {
            this.memberShape = memberShape;
            this.dataSetter = dataSetter;
        }

        protected Void getDefault(Shape shape) {
            return null;
        }

        public Void stringShape(StringShape shape) {
            ParserGenerator.this.writer.write((Object)"payload = http_resp.body.read", new Object[0]).write((Object)"$Lpayload unless payload.empty?", new Object[]{this.dataSetter});
            return null;
        }

        public Void blobShape(BlobShape shape) {
            ParserGenerator.this.writer.write((Object)"payload = http_resp.body.read", new Object[0]).write((Object)"$Lpayload unless payload.empty?", new Object[]{this.dataSetter});
            return null;
        }

        public Void listShape(ListShape shape) {
            this.defaultComplexDeserializer((Shape)shape);
            return null;
        }

        public Void mapShape(MapShape shape) {
            this.defaultComplexDeserializer((Shape)shape);
            return null;
        }

        public Void structureShape(StructureShape shape) {
            this.defaultComplexDeserializer((Shape)shape);
            return null;
        }

        public Void unionShape(UnionShape shape) {
            this.defaultComplexDeserializer((Shape)shape);
            return null;
        }

        private void defaultComplexDeserializer(Shape shape) {
            ParserGenerator.this.writer.write((Object)"json = Seahorse::JSON.load(http_resp.body)", new Object[0]).write((Object)"$LParsers::$L.parse(json)", new Object[]{this.dataSetter, ParserGenerator.this.symbolProvider.toSymbol(shape).getName()});
        }
    }

    private class MemberDeserializer
    extends ShapeVisitor.Default<Void> {
        private final String jsonGetter;
        private final String dataSetter;
        private final MemberShape memberShape;

        MemberDeserializer(MemberShape memberShape, String dataSetter, String jsonGetter) {
            this.jsonGetter = jsonGetter;
            this.dataSetter = dataSetter;
            this.memberShape = memberShape;
        }

        protected Void getDefault(Shape shape) {
            ParserGenerator.this.writer.write((Object)"$L$L", new Object[]{this.dataSetter, this.jsonGetter});
            return null;
        }

        public Void blobShape(BlobShape shape) {
            ParserGenerator.this.writer.write((Object)"$1LBase64::decode64($2L) if $2L", new Object[]{this.dataSetter, this.jsonGetter});
            return null;
        }

        public Void timestampShape(TimestampShape shape) {
            Optional format = this.memberShape.getTrait(TimestampFormatTrait.class);
            if (format.isPresent()) {
                switch (((TimestampFormatTrait)format.get()).getFormat()) {
                    case EPOCH_SECONDS: {
                        ParserGenerator.this.writer.write((Object)"$1LTime.at($2L.to_i) if $2L", new Object[]{this.dataSetter, this.jsonGetter});
                        break;
                    }
                    default: {
                        ParserGenerator.this.writer.write((Object)"$1LTime.parse($2L) if $2L", new Object[]{this.dataSetter, this.jsonGetter});
                        break;
                    }
                }
            } else {
                ParserGenerator.this.writer.write((Object)"$1LTime.parse($2L) if $2L", new Object[]{this.dataSetter, this.jsonGetter});
            }
            return null;
        }

        private void defaultComplexDeserializer(Shape shape) {
            ParserGenerator.this.writer.write((Object)"$1LParsers::$2L.parse($3L) if $3L", new Object[]{this.dataSetter, ParserGenerator.this.symbolProvider.toSymbol(shape).getName(), this.jsonGetter});
        }

        public Void listShape(ListShape shape) {
            this.defaultComplexDeserializer((Shape)shape);
            return null;
        }

        public Void mapShape(MapShape shape) {
            this.defaultComplexDeserializer((Shape)shape);
            return null;
        }

        public Void structureShape(StructureShape shape) {
            this.defaultComplexDeserializer((Shape)shape);
            return null;
        }

        public Void unionShape(UnionShape shape) {
            this.defaultComplexDeserializer((Shape)shape);
            return null;
        }
    }
}

