/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.middleware.factories;

import java.util.List;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.config.ClientConfig;
import software.amazon.smithy.ruby.codegen.config.RespondsToConstraint;
import software.amazon.smithy.ruby.codegen.middleware.Middleware;
import software.amazon.smithy.ruby.codegen.middleware.MiddlewareStackStep;

public final class RetryMiddlewareFactory {
    private RetryMiddlewareFactory() {
    }

    public static Middleware build(GenerationContext context) {
        String retryStrategyDocumentation = "Specifies which retry strategy class to use. Strategy classes may have additional\noptions, such as `max_retries` and backoff strategies.\n\nAvailable options are:\n* `Retry::Standard` - A standardized set of retry rules across the AWS SDKs. This\n  includes support for retry quotas, which limit the number of unsuccessful retries\n  a client can make.\n* `Retry::Adaptive` - An experimental retry mode that includes all the functionality\n  of `standard` mode along with automatic client side throttling. This is a provisional\n  mode that may change behavior in the future.\n";
        String retryStrategyTypes = "#acquire_initial_retry_token(token_scope),#refresh_retry_token(retry_token, error_info),#record_success(retry_token)";
        ClientConfig retryStrategy = ClientConfig.builder().name("retry_strategy").defaultValue("Hearth::Retry::Standard.new").documentation(retryStrategyDocumentation).rbsType("Hearth::_RetryStrategy").documentationType(retryStrategyTypes).documentationDefaultValue("Hearth::Retry::Standard.new").constraint(new RespondsToConstraint(List.of("acquire_initial_retry_token", "refresh_retry_token", "record_success"))).build();
        return Middleware.builder().klass(Hearth.RETRY_MIDDLEWARE).step(MiddlewareStackStep.RETRY).addConfig(retryStrategy).addParam("error_inspector_class", context.applicationTransport().getErrorInspector()).build();
    }
}

