/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators.docs;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.EnumShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.DeprecatedTrait;
import software.amazon.smithy.model.traits.DocumentationTrait;
import software.amazon.smithy.model.traits.ExamplesTrait;
import software.amazon.smithy.model.traits.ExternalDocumentationTrait;
import software.amazon.smithy.model.traits.InternalTrait;
import software.amazon.smithy.model.traits.RecommendedTrait;
import software.amazon.smithy.model.traits.SensitiveTrait;
import software.amazon.smithy.model.traits.SinceTrait;
import software.amazon.smithy.model.traits.TagsTrait;
import software.amazon.smithy.model.traits.UnstableTrait;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.generators.docs.PlaceholderExampleGenerator;
import software.amazon.smithy.ruby.codegen.generators.docs.ResponseExampleGenerator;
import software.amazon.smithy.ruby.codegen.generators.docs.TraitExampleGenerator;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class ShapeDocumentationGenerator {
    private final Model model;
    private final RubyCodeWriter writer;
    private final SymbolProvider symbolProvider;
    private final Shape shape;

    public ShapeDocumentationGenerator(Model model, RubyCodeWriter writer, SymbolProvider symbolProvider, Shape shape) {
        this.writer = writer;
        this.model = model;
        this.symbolProvider = symbolProvider;
        this.shape = shape;
    }

    public void render() {
        this.shape.accept((ShapeVisitor)new ShapeDocumentationVisitor());
    }

    private void writeDocumentationTrait(Optional<DocumentationTrait> optionalDocumentationTrait) {
        if (optionalDocumentationTrait.isPresent()) {
            String documentation = optionalDocumentationTrait.get().getValue();
            this.writer.writeDocstring(documentation);
        }
    }

    private void writeSinceTrait(Optional<SinceTrait> optionalSinceTrait) {
        if (optionalSinceTrait.isPresent()) {
            String since = optionalSinceTrait.get().getValue();
            this.writer.writeYardSince(since);
        }
    }

    private void writeUnstableTrait(Optional<UnstableTrait> optionalUnstableTrait) {
        if (optionalUnstableTrait.isPresent()) {
            this.writer.writeYardNote("This shape is unstable and may change in the future.");
        }
    }

    private void writeInternalTrait(Optional<InternalTrait> optionalInternalTrait) {
        if (optionalInternalTrait.isPresent()) {
            this.writer.writeYardNote("This shape is meant for internal use only.");
        }
    }

    private void writeRecommendedTrait(Optional<RecommendedTrait> optionalRecommendedTrait) {
        Optional optionalReason;
        if (optionalRecommendedTrait.isPresent() && (optionalReason = optionalRecommendedTrait.get().getReason()).isPresent()) {
            String documentation = "This shape is recommended.\nReason: " + (String)optionalReason.get();
            this.writer.writeYardNote(documentation);
        }
    }

    private void writeExternalDocumentationTrait(Optional<ExternalDocumentationTrait> optionalExternalDocumentationTrait) {
        if (optionalExternalDocumentationTrait.isPresent()) {
            Map urls = optionalExternalDocumentationTrait.get().getUrls();
            for (Map.Entry entry : urls.entrySet()) {
                this.writer.writeYardSee((String)entry.getValue(), (String)entry.getKey());
            }
        }
    }

    private void writeDeprecatedTrait(Optional<DeprecatedTrait> optionalDeprecatedTrait) {
        if (optionalDeprecatedTrait.isPresent()) {
            DeprecatedTrait deprecatedTrait = optionalDeprecatedTrait.get();
            String message = deprecatedTrait.getMessage().orElse("");
            String since = deprecatedTrait.getSince().orElse("");
            this.writer.writeYardDeprecated(message, since);
        }
    }

    private void writeTagsTrait(Optional<TagsTrait> optionalTagsTrait) {
        if (optionalTagsTrait.isPresent()) {
            String tags = optionalTagsTrait.get().getValues().stream().map(tag -> "\"" + tag + "\"").collect(Collectors.joining(", "));
            this.writer.writeDocstring("Tags: [" + tags + "]");
        }
    }

    private void writeExamplesTrait(Optional<ExamplesTrait> optionalExamplesTrait) {
        if (optionalExamplesTrait.isPresent()) {
            List examples = optionalExamplesTrait.get().getExamples();
            examples.forEach(example -> {
                String title = example.getTitle();
                this.writer.writeYardExample(title, new TraitExampleGenerator((OperationShape)this.shape, this.symbolProvider, this.model, (ExamplesTrait.Example)example).generate());
            });
        }
    }

    private void writeSensitiveTrait(Optional<SensitiveTrait> optionalSensitiveTrait) {
        if (optionalSensitiveTrait.isPresent()) {
            this.writer.writeYardNote("This shape is sensitive and must be handled with care.");
        }
    }

    private void writeAllShapeTraits() {
        Optional optionalDocumentationTrait = this.shape.getTrait(DocumentationTrait.class);
        Optional optionalDeprecatedTrait = this.shape.getTrait(DeprecatedTrait.class);
        Optional optionalExternalDocumentationTrait = this.shape.getTrait(ExternalDocumentationTrait.class);
        Optional optionalInternalTrait = this.shape.getTrait(InternalTrait.class);
        Optional optionalSinceTrait = this.shape.getTrait(SinceTrait.class);
        Optional optionalTagsTrait = this.shape.getTrait(TagsTrait.class);
        Optional optionalUnstableTrait = this.shape.getTrait(UnstableTrait.class);
        Optional optionalSensitiveTrait = this.shape.getTrait(SensitiveTrait.class);
        this.writeDocumentationTrait(optionalDocumentationTrait);
        this.writeDeprecatedTrait(optionalDeprecatedTrait);
        this.writeUnstableTrait(optionalUnstableTrait);
        this.writeExternalDocumentationTrait(optionalExternalDocumentationTrait);
        this.writeInternalTrait(optionalInternalTrait);
        this.writeSinceTrait(optionalSinceTrait);
        this.writeSensitiveTrait(optionalSensitiveTrait);
        this.writeTagsTrait(optionalTagsTrait);
    }

    private class ShapeDocumentationVisitor
    extends ShapeVisitor.Default<Void> {
        private ShapeDocumentationVisitor() {
        }

        protected Void getDefault(Shape shape) {
            return null;
        }

        public Void structureShape(StructureShape shape) {
            ShapeDocumentationGenerator.this.writeAllShapeTraits();
            return null;
        }

        public Void unionShape(UnionShape shape) {
            ShapeDocumentationGenerator.this.writeAllShapeTraits();
            return null;
        }

        public Void enumShape(EnumShape shape) {
            ShapeDocumentationGenerator.this.writeAllShapeTraits();
            return null;
        }

        public Void memberShape(MemberShape shape) {
            Optional optionalMemberDocumentationTrait = shape.getMemberTrait(ShapeDocumentationGenerator.this.model, DocumentationTrait.class);
            Optional optionalMemberDeprecatedTrait = shape.getMemberTrait(ShapeDocumentationGenerator.this.model, DeprecatedTrait.class);
            Optional optionalMemberExternalDocumentationTrait = shape.getMemberTrait(ShapeDocumentationGenerator.this.model, ExternalDocumentationTrait.class);
            Optional optionalMemberInternalTrait = shape.getMemberTrait(ShapeDocumentationGenerator.this.model, InternalTrait.class);
            Optional optionalMemberRecommendedTrait = shape.getMemberTrait(ShapeDocumentationGenerator.this.model, RecommendedTrait.class);
            Optional optionalMemberSinceTrait = shape.getMemberTrait(ShapeDocumentationGenerator.this.model, SinceTrait.class);
            Optional optionalMemberTagsTrait = shape.getMemberTrait(ShapeDocumentationGenerator.this.model, TagsTrait.class);
            Optional optionalMemberUnstableTrait = shape.getMemberTrait(ShapeDocumentationGenerator.this.model, UnstableTrait.class);
            ShapeDocumentationGenerator.this.writeDocumentationTrait(optionalMemberDocumentationTrait);
            Shape target = ShapeDocumentationGenerator.this.model.expectShape(shape.getTarget());
            if (target.isEnumShape()) {
                String enumValues = ((EnumShape)target.asEnumShape().get()).getEnumValues().values().stream().map(value -> "\"" + value + "\"").collect(Collectors.joining(", "));
                ShapeDocumentationGenerator.this.writer.writeDocstring("Enum, one of: [" + enumValues + "]");
            }
            ShapeDocumentationGenerator.this.writeDeprecatedTrait(optionalMemberDeprecatedTrait);
            ShapeDocumentationGenerator.this.writeUnstableTrait(optionalMemberUnstableTrait);
            ShapeDocumentationGenerator.this.writeExternalDocumentationTrait(optionalMemberExternalDocumentationTrait);
            ShapeDocumentationGenerator.this.writeInternalTrait(optionalMemberInternalTrait);
            ShapeDocumentationGenerator.this.writeRecommendedTrait(optionalMemberRecommendedTrait);
            ShapeDocumentationGenerator.this.writeSinceTrait(optionalMemberSinceTrait);
            ShapeDocumentationGenerator.this.writeTagsTrait(optionalMemberTagsTrait);
            return null;
        }

        public Void operationShape(OperationShape shape) {
            ShapeDocumentationGenerator.this.writeAllShapeTraits();
            Shape inputShape = ShapeDocumentationGenerator.this.model.expectShape(shape.getInputShape());
            String inputShapeName = ShapeDocumentationGenerator.this.symbolProvider.toSymbol(inputShape).getName();
            String paramsDocString = "Request parameters for this operation.\nSee {Types::%s#initialize} for available parameters.\n".formatted(inputShapeName);
            String optionsDocString = "Request option override of configuration. See {Config#initialize} for available options.\nSome configurations cannot be overridden.\n";
            ShapeDocumentationGenerator.this.writer.writeYardParam("Hash | Types::" + inputShapeName, "params", paramsDocString).writeYardParam("Hash", "options", optionsDocString).writeYardReturn("" + Hearth.OUTPUT, "").writeYardExample("Request syntax with placeholder values", new PlaceholderExampleGenerator(shape, ShapeDocumentationGenerator.this.symbolProvider, ShapeDocumentationGenerator.this.model).generate()).writeYardExample("Response structure", new ResponseExampleGenerator(shape, ShapeDocumentationGenerator.this.symbolProvider, ShapeDocumentationGenerator.this.model).generate());
            Optional optionalExamplesTrait = shape.getTrait(ExamplesTrait.class);
            ShapeDocumentationGenerator.this.writeExamplesTrait(optionalExamplesTrait);
            return null;
        }

        public Void serviceShape(ServiceShape shape) {
            ShapeDocumentationGenerator.this.writeAllShapeTraits();
            return null;
        }
    }
}

