/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.logging.Logger;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.codegen.core.directed.ContextualDirective;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class VersionGenerator {
    private static final Logger LOGGER = Logger.getLogger(VersionGenerator.class.getName());
    private final GenerationContext context;
    private final RubySettings settings;

    public VersionGenerator(ContextualDirective<GenerationContext, RubySettings> directive) {
        this.context = (GenerationContext)directive.context();
        this.settings = (RubySettings)directive.settings();
    }

    public void render() {
        String fileName = this.settings.getGemName() + "/VERSION";
        FileManifest fileManifest = this.context.fileManifest();
        RubyCodeWriter writer = new RubyCodeWriter(this.context.settings().getModule());
        writer.write("$L", new Object[]{this.settings.getGemVersion()});
        fileManifest.writeFile(fileName, writer.toString());
    }
}

