/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.codegen.core.directed.ContextualDirective;
import software.amazon.smithy.codegen.core.directed.GenerateServiceDirective;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.traits.StreamingTrait;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.RubyImportContainer;
import software.amazon.smithy.ruby.codegen.RubyRuntimePlugin;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.RubySymbolProvider;
import software.amazon.smithy.ruby.codegen.config.ClientConfig;
import software.amazon.smithy.ruby.codegen.generators.RubyGeneratorBase;
import software.amazon.smithy.ruby.codegen.generators.docs.ShapeDocumentationGenerator;
import software.amazon.smithy.ruby.codegen.generators.rbs.OperationKeywordArgRbsVisitor;
import software.amazon.smithy.ruby.codegen.util.Streaming;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class ClientGenerator
extends RubyGeneratorBase {
    private static final Logger LOGGER = Logger.getLogger(ClientGenerator.class.getName());
    private final Set<OperationShape> operations;
    private final Set<RubyRuntimePlugin> runtimePlugins;
    private final List<ClientConfig> clientConfigList;

    public ClientGenerator(GenerateServiceDirective<GenerationContext, RubySettings> directive, List<ClientConfig> clientConfigList) {
        super((ContextualDirective<GenerationContext, RubySettings>)directive);
        this.operations = directive.operations();
        this.runtimePlugins = this.context.getRuntimePlugins();
        this.clientConfigList = clientConfigList;
    }

    @Override
    String getModule() {
        return "Client";
    }

    public void render() {
        List additionalFiles = this.runtimePlugins.stream().map(plugin -> plugin.writeAdditionalFiles(this.context)).flatMap(Collection::stream).distinct().sorted().collect(Collectors.toList());
        additionalFiles.sort(String::compareTo);
        this.write(writer -> ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.preamble().includeRequires().writeRequireRelativeAdditionalFiles(additionalFiles).openBlock("module $L", new Object[]{this.settings.getModule()})).call(() -> new ShapeDocumentationGenerator(this.model, (RubyCodeWriter)((Object)writer), this.symbolProvider, (Shape)this.context.service()).render())).openBlock("class Client < $T", new Object[]{Hearth.CLIENT})).write("", new Object[0])).call(() -> this.renderClassRuntimePlugins((RubyCodeWriter)((Object)writer)))).write("", new Object[0])).call(() -> this.renderInitializeMethod((RubyCodeWriter)((Object)writer)))).write("\n# @return [Config] config", new Object[0])).write("attr_reader :config\n", new Object[0])).call(() -> this.renderOperations((RubyCodeWriter)((Object)writer)))).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]));
        LOGGER.fine("Wrote client to " + this.rbFile());
    }

    public void renderRbs() {
        this.writeRbs(writer -> ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.preamble().openBlock("module $L", new Object[]{this.settings.getModule()})).openBlock("class Client < $T", new Object[]{Hearth.CLIENT})).write("", new Object[0])).write("def self.plugins: () -> Hearth::PluginList[Config]", new Object[0])).write("", new Object[0])).openBlock("def initialize: (?::Hash[::Symbol, untyped] options) -> void |", new Object[0])).call(() -> this.renderInitializeRbs((RubyCodeWriter)((Object)writer)))).closeBlock("", new Object[0])).write("", new Object[0])).write("attr_reader config: Config", new Object[0])).write("", new Object[0])).call(() -> this.renderRbsOperations((RubyCodeWriter)((Object)writer)))).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]));
        LOGGER.fine("Wrote client rbs to " + this.rbsFile());
    }

    private void renderInitializeRbs(RubyCodeWriter writer) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("(", new Object[0])).call(() -> this.clientConfigList.forEach(clientConfig -> {
            String member = RubySymbolProvider.toMemberName(clientConfig.getName());
            String rbsType = clientConfig.getRbsType();
            writer.write("?$L: $L,", new Object[]{member, rbsType});
        }))).unwrite(",\n", new Object[0])).closeBlock("\n) -> void", new Object[0]);
    }

    private void renderClassRuntimePlugins(RubyCodeWriter writer) {
        writer.apiPrivate();
        if (this.runtimePlugins.isEmpty()) {
            writer.write("@plugins = $T.new", new Object[]{Hearth.PLUGIN_LIST});
        } else {
            writer.openBlock("@plugins = $T.new([", new Object[]{Hearth.PLUGIN_LIST});
            writer.write(this.runtimePlugins.stream().map(p -> p.renderAdd(this.context)).collect(Collectors.joining(",\n")), new Object[0]);
            writer.closeBlock("])", new Object[0]);
        }
    }

    private void renderInitializeMethod(RubyCodeWriter writer) {
        ((RubyCodeWriter)((RubyCodeWriter)writer.writeYardParam("Hash", "options", "Options used to construct an instance of {Config}").openBlock("def initialize(options = {})", new Object[0])).write("super(options, Config)", new Object[0])).closeBlock("end", new Object[0]);
    }

    private void renderOperations(RubyCodeWriter writer) {
        this.operations.stream().filter(o -> !Streaming.isEventStreaming(this.model, o)).sorted(Comparator.comparing(o -> o.getId().getName())).forEach(o -> this.renderOperation(writer, (OperationShape)o));
    }

    private void renderRbsOperations(RubyCodeWriter writer) {
        this.operations.stream().sorted(Comparator.comparing(o -> o.getId().getName())).forEach(o -> this.renderRbsOperation(writer, (OperationShape)o));
    }

    private void renderOperation(RubyCodeWriter writer, OperationShape operation) {
        Shape inputShape = this.model.expectShape(operation.getInputShape());
        Shape outputShape = this.model.expectShape(operation.getOutputShape());
        String classOperationName = this.symbolProvider.toSymbol((Shape)operation).getName();
        String operationName = RubyFormatter.toSnakeCase(classOperationName);
        boolean isStreaming = Streaming.isStreaming(this.model, outputShape);
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.write("", new Object[0])).call(() -> new ShapeDocumentationGenerator(this.model, writer, this.symbolProvider, (Shape)operation).render())).call(() -> {
            if (isStreaming) {
                ((RubyCodeWriter)writer.openBlock("def $L(params = {}, options = {}, &block)", new Object[]{operationName})).write("response_body = output_stream(options, &block)", new Object[0]);
            } else {
                ((RubyCodeWriter)writer.openBlock("def $L(params = {}, options = {})", new Object[]{operationName})).write("response_body = $T.new", new Object[]{RubyImportContainer.STRING_IO});
            }
        })).write("config = operation_config(options)", new Object[0])).write("input = Params::$L.build(params, context: 'params')", new Object[]{this.symbolProvider.toSymbol(inputShape).getName()})).write("stack = $L::Middleware::$L.build(config)", new Object[]{this.settings.getModule(), classOperationName})).openBlock("context = $T.new(", new Object[]{Hearth.CONTEXT})).write("request: $L,", new Object[]{this.context.applicationTransport().getRequest().render(this.context)})).write("response: $L,", new Object[]{this.context.applicationTransport().getResponse().render(this.context)})).write("logger: config.logger,", new Object[0])).write("operation_name: :$L,", new Object[]{operationName})).write("interceptors: config.interceptors", new Object[0])).closeBlock(")", new Object[0])).write("context.logger.info(\"[#{context.invocation_id}] [#{self.class}#$L] params: #{params}, options: #{options}\")", new Object[]{operationName})).write("output = stack.run(input, context)", new Object[0])).openBlock("if output.error", new Object[0])).write("context.logger.error(\"[#{context.invocation_id}] [#{self.class}#$L] #{output.error} (#{output.error.class})\")", new Object[]{operationName})).write("raise output.error", new Object[0])).closeBlock("end", new Object[0])).write("context.logger.info(\"[#{context.invocation_id}] [#{self.class}#$L] #{output.data}\")", new Object[]{operationName})).write("output", new Object[0])).closeBlock("end", new Object[0]);
    }

    private void renderRbsOperation(RubyCodeWriter writer, OperationShape operation) {
        String operationName = RubyFormatter.toSnakeCase(this.symbolProvider.toSymbol((Shape)operation).getName());
        Shape outputShape = this.model.expectShape(operation.getOutputShape());
        Shape inputShape = this.model.expectShape(operation.getInputShape());
        boolean isStreaming = outputShape.members().stream().anyMatch(m -> m.getMemberTrait(this.model, StreamingTrait.class).isPresent());
        String streamingBlock = isStreaming ? " ?{ (::String) -> Hearth::BlockIO }" : "";
        String dataType = this.symbolProvider.toSymbol(outputShape).getName();
        String inputType = this.symbolProvider.toSymbol(inputShape).getName();
        RubyCodeWriter operationRbsWriter = new RubyCodeWriter("");
        operation.accept((ShapeVisitor)new OperationKeywordArgRbsVisitor(this.context, operationRbsWriter));
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("def $L: (?::Hash[::Symbol, untyped] params, ?::Hash[::Symbol, untyped] options) $L -> Hearth::Output[Types::$L] |", new Object[]{operationName, streamingBlock, dataType})).write("(?Types::$L params, ?::Hash[::Symbol, untyped] options) $L -> Hearth::Output[Types::$L] |", new Object[]{inputType, streamingBlock, dataType})).call(() -> {
            if (!inputShape.members().isEmpty()) {
                ((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("(", new Object[0])).write(operationRbsWriter.toString().trim(), new Object[0])).closeBlock(")$L -> Hearth::Output[Types::$L]", new Object[]{streamingBlock, dataType});
            } else {
                writer.unwrite("|\n", new Object[0]);
            }
        })).closeBlock("", new Object[0]);
    }
}

