/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.MediaTypeTrait;
import software.amazon.smithy.model.traits.RequiresLengthTrait;
import software.amazon.smithy.model.traits.StreamingTrait;
import software.amazon.smithy.ruby.codegen.CodegenUtils;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.util.Streaming;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public abstract class BuilderGeneratorBase {
    private static final Logger LOGGER = Logger.getLogger(BuilderGeneratorBase.class.getName());
    protected final GenerationContext context;
    protected final RubySettings settings;
    protected final Model model;
    protected final Set<ShapeId> generatedBuilders;
    protected final RubyCodeWriter writer;
    protected final SymbolProvider symbolProvider;

    public BuilderGeneratorBase(GenerationContext context) {
        this.settings = context.settings();
        this.model = context.model();
        this.generatedBuilders = new HashSet<ShapeId>();
        this.context = context;
        this.writer = new RubyCodeWriter(context.settings().getModule() + "::Builder");
        this.symbolProvider = context.symbolProvider();
    }

    protected abstract void renderOperationBuildMethod(OperationShape var1, Shape var2);

    protected abstract void renderStructureBuildMethod(StructureShape var1);

    protected abstract void renderListBuildMethod(ListShape var1);

    protected abstract void renderUnionBuildMethod(UnionShape var1);

    protected abstract void renderMapBuildMethod(MapShape var1);

    public void render(FileManifest fileManifest) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.preamble().includeRequires().openBlock("module $L", new Object[]{this.settings.getModule()})).apiPrivate().openBlock("module Builders", new Object[0])).call(() -> this.renderBuilders())).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
        String fileName = this.settings.getGemName() + "/lib/" + this.settings.getGemName() + "/builders.rb";
        fileManifest.writeFile(fileName, this.writer.toString());
        LOGGER.fine("Wrote builders to " + fileName);
    }

    protected void renderBuilders() {
        TreeSet<Shape> shapesToBeRendered = CodegenUtils.getAlphabeticalOrderedShapesSet();
        TopDownIndex topDownIndex = TopDownIndex.of((Model)this.model);
        TreeSet containedOperations = new TreeSet(topDownIndex.getContainedOperations((ToShapeId)this.context.service()));
        containedOperations.stream().filter(o -> !Streaming.isEventStreaming(this.model, o)).forEach(o -> {
            Shape inputShape = this.model.expectShape(o.getInputShape());
            shapesToBeRendered.add((Shape)o);
            this.generatedBuilders.add(o.toShapeId());
            this.generatedBuilders.add(inputShape.toShapeId());
            Iterator it = new Walker(this.model).iterateShapes(inputShape);
            while (it.hasNext()) {
                Shape s = (Shape)it.next();
                if (this.generatedBuilders.contains(s.getId())) continue;
                this.generatedBuilders.add(s.getId());
                shapesToBeRendered.add(s);
            }
        });
        shapesToBeRendered.forEach(shape -> {
            if (shape instanceof OperationShape) {
                OperationShape operation = (OperationShape)shape;
                Shape inputShape = this.model.expectShape(operation.getInputShape());
                this.renderBuildersForOperation(operation, inputShape);
            } else {
                shape.accept((ShapeVisitor)new BuilderClassGenerator());
            }
        });
    }

    protected void renderBuildersForOperation(OperationShape operation, Shape inputShape) {
        Symbol symbol = this.symbolProvider.toSymbol((Shape)operation);
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write("", new Object[0])).openBlock("class $L", new Object[]{symbol.getName()})).call(() -> this.renderOperationBuildMethod(operation, inputShape))).closeBlock("end", new Object[0]);
    }

    protected void renderStreamingBodyBuilder(Shape inputShape) {
        MemberShape streamingMember = inputShape.members().stream().filter(m -> m.getMemberTrait(this.model, StreamingTrait.class).isPresent()).findFirst().get();
        Shape target = this.model.expectShape(streamingMember.getTarget());
        this.writer.write("http_req.body = input[:$L]", new Object[]{this.symbolProvider.toMemberName(streamingMember)});
        if (!target.hasTrait(RequiresLengthTrait.class)) {
            this.writer.write("http_req.headers['Transfer-Encoding'] = 'chunked'", new Object[0]);
        }
        if (target.hasTrait(MediaTypeTrait.class)) {
            this.writer.write("http_req.headers['Content-Type'] = '$L'", new Object[]{((MediaTypeTrait)target.expectTrait(MediaTypeTrait.class)).getValue()});
        } else {
            this.writer.write("http_req.headers['Content-Type'] = 'application/octet-stream'", new Object[0]);
        }
    }

    protected class BuilderClassGenerator
    extends ShapeVisitor.Default<Void> {
        protected BuilderClassGenerator() {
        }

        protected Void getDefault(Shape shape) {
            return null;
        }

        public Void structureShape(StructureShape shape) {
            Symbol symbol = BuilderGeneratorBase.this.symbolProvider.toSymbol((Shape)shape);
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)BuilderGeneratorBase.this.writer.write("", new Object[0])).openBlock("class $L", new Object[]{symbol.getName()})).call(() -> BuilderGeneratorBase.this.renderStructureBuildMethod(shape))).closeBlock("end", new Object[0]);
            return null;
        }

        public Void listShape(ListShape shape) {
            Symbol symbol = BuilderGeneratorBase.this.symbolProvider.toSymbol((Shape)shape);
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)BuilderGeneratorBase.this.writer.write("", new Object[0])).openBlock("class $L", new Object[]{symbol.getName()})).call(() -> BuilderGeneratorBase.this.renderListBuildMethod(shape))).closeBlock("end", new Object[0]);
            return null;
        }

        public Void mapShape(MapShape shape) {
            Symbol symbol = BuilderGeneratorBase.this.symbolProvider.toSymbol((Shape)shape);
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)BuilderGeneratorBase.this.writer.write("", new Object[0])).openBlock("class $L", new Object[]{symbol.getName()})).call(() -> BuilderGeneratorBase.this.renderMapBuildMethod(shape))).closeBlock("end", new Object[0]);
            return null;
        }

        public Void unionShape(UnionShape shape) {
            Symbol symbol = BuilderGeneratorBase.this.symbolProvider.toSymbol((Shape)shape);
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)BuilderGeneratorBase.this.writer.write("", new Object[0])).openBlock("class $L", new Object[]{symbol.getName()})).call(() -> BuilderGeneratorBase.this.renderUnionBuildMethod(shape))).closeBlock("end", new Object[0]);
            return null;
        }
    }
}

