/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen;

import java.util.Set;
import java.util.TreeSet;
import software.amazon.smithy.codegen.core.ImportContainer;
import software.amazon.smithy.codegen.core.SmithyIntegration;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolDependency;
import software.amazon.smithy.codegen.core.SymbolDependencyContainer;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyDependency;
import software.amazon.smithy.ruby.codegen.RubySettings;

public class RubyImportContainer
implements ImportContainer,
SmithyIntegration<RubySettings, RubyCodeWriter, GenerationContext> {
    public static final Symbol SECURE_RANDOM = Symbol.builder().name("SecureRandom").addDependency((SymbolDependencyContainer)RubyDependency.SECURE_RANDOM).build();
    public static final Symbol BASE64 = Symbol.builder().name("Base64").addDependency((SymbolDependencyContainer)RubyDependency.BASE64).build();
    public static final Symbol BIG_DECIMAL = Symbol.builder().name("BigDecimal").addDependency((SymbolDependencyContainer)RubyDependency.BIG_DECIMAL).build();
    public static final Symbol STRING_IO = Symbol.builder().name("StringIO").addDependency((SymbolDependencyContainer)RubyDependency.STRING_IO).build();
    public static final Symbol CGI = Symbol.builder().name("CGI").addDependency((SymbolDependencyContainer)RubyDependency.CGI).build();
    public static final Symbol TIME = Symbol.builder().name("Time").addDependency((SymbolDependencyContainer)RubyDependency.TIME).build();
    private final String namespace;
    private final Set<String> requires = new TreeSet<String>();

    public RubyImportContainer(String namespace) {
        this.namespace = namespace;
    }

    public void importSymbol(Symbol symbol, String alias) {
        symbol.getDependencies().forEach(d -> this.importDependency((SymbolDependency)d));
    }

    public void importDependency(SymbolDependency dependency) {
        if (this.shouldRequire(dependency.getDependencyType())) {
            this.requires.add(dependency.getPackageName());
        }
    }

    private boolean shouldRequire(String dependencyType) {
        return dependencyType.equals(RubyDependency.Type.DEPENDENCY.toString()) || dependencyType.equals(RubyDependency.Type.STANDARD_LIBRARY.toString());
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        this.requires.forEach(r -> result.append(String.format("require '%s'%n", r)));
        return result.toString();
    }
}

