/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import software.amazon.smithy.codegen.core.SymbolDependency;
import software.amazon.smithy.codegen.core.SymbolDependencyContainer;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public final class RubyDependency
implements SymbolDependencyContainer,
Comparable<RubyDependency> {
    public static final RubyDependency HEARTH = new Builder().type(Type.DEPENDENCY).importPath("hearth").gemName("hearth").version("~> 1.0.0.pre3").build();
    public static final RubyDependency HEARTH_XML_MATCHER = new Builder().type(Type.DEPENDENCY).importPath("hearth/xml/node_matcher").build();
    public static final RubyDependency HEARTH_QUERY_PARAM_MATCHER = new Builder().type(Type.DEPENDENCY).importPath("hearth/query/param_matcher").build();
    public static final RubyDependency SECURE_RANDOM = new Builder().type(Type.STANDARD_LIBRARY).importPath("securerandom").build();
    public static final RubyDependency BASE64 = new Builder().type(Type.STANDARD_LIBRARY).importPath("base64").build();
    public static final RubyDependency BIG_DECIMAL = new Builder().type(Type.STANDARD_LIBRARY).importPath("bigdecimal").build();
    public static final RubyDependency STRING_IO = new Builder().type(Type.STANDARD_LIBRARY).importPath("stringio").build();
    public static final RubyDependency CGI = new Builder().type(Type.STANDARD_LIBRARY).importPath("cgi").build();
    public static final RubyDependency TIME = new Builder().type(Type.STANDARD_LIBRARY).importPath("time").build();
    private final Type type;
    private final String gemName;
    private final String importPath;
    private final String version;
    private final Set<RubyDependency> dependencies;
    private final SymbolDependency symbolDependency;

    private RubyDependency(Builder builder) {
        this.type = (Type)((Object)SmithyBuilder.requiredState((String)"type", (Object)((Object)builder.type)));
        this.gemName = builder.gemName;
        this.importPath = (String)SmithyBuilder.requiredState((String)"importPath", (Object)builder.importPath);
        this.version = builder.version != null ? builder.version : ">= 0";
        this.dependencies = (Set)SmithyBuilder.requiredState((String)"dependencies", builder.dependencies);
        this.symbolDependency = SymbolDependency.builder().dependencyType(this.type.toString()).packageName(this.importPath).version(this.version).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public SymbolDependency getSymbolDependency() {
        return this.symbolDependency;
    }

    public Type getType() {
        return this.type;
    }

    public String getGemName() {
        return this.gemName;
    }

    public String getImportPath() {
        return this.importPath;
    }

    public String getVersion() {
        return this.version;
    }

    public List<SymbolDependency> getDependencies() {
        TreeSet symbolDependencySet = new TreeSet(SetUtils.of((Object)this.getSymbolDependency()));
        this.dependencies.forEach(d -> symbolDependencySet.add(d.getSymbolDependency()));
        return new ArrayList<SymbolDependency>(symbolDependencySet);
    }

    public Set<RubyDependency> getRubyDependencies() {
        return this.dependencies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RubyDependency)) {
            return false;
        }
        RubyDependency other = (RubyDependency)o;
        return this.type.equals((Object)other.type) && this.importPath.equals(other.importPath) && this.version.equals(other.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.importPath, this.version});
    }

    @Override
    public int compareTo(RubyDependency o) {
        if (this.equals(o)) {
            return 0;
        }
        int importPathCompare = this.importPath.compareTo(o.importPath);
        if (importPathCompare != 0) {
            return importPathCompare;
        }
        return this.version.compareTo(o.version);
    }

    public static final class Builder
    implements SmithyBuilder<RubyDependency> {
        private final Set<RubyDependency> dependencies = new TreeSet<RubyDependency>();
        private Type type;
        private String gemName;
        private String importPath;
        private String version;

        private Builder() {
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder gemName(String gemName) {
            this.gemName = gemName;
            return this;
        }

        public Builder importPath(String importPath) {
            this.importPath = importPath;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder dependencies(Collection<RubyDependency> dependencies) {
            this.dependencies.clear();
            this.dependencies.addAll(dependencies);
            return this;
        }

        public Builder addDependency(RubyDependency dependency) {
            this.dependencies.add(dependency);
            return this;
        }

        public Builder removeDependency(RubyDependency dependency) {
            this.dependencies.remove(dependency);
            return this;
        }

        public RubyDependency build() {
            return new RubyDependency(this);
        }
    }

    public static enum Type {
        STANDARD_LIBRARY,
        DEPENDENCY,
        SDK_INTERNAL;


        public String toString() {
            switch (this) {
                case STANDARD_LIBRARY: {
                    return "stdlib";
                }
                case DEPENDENCY: {
                    return "dependency";
                }
                case SDK_INTERNAL: {
                    return "sdk_internal";
                }
            }
            return "unknown";
        }
    }
}

