/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.WriteAdditionalFiles;

public final class RubySource {
    private RubySource() {
    }

    public static WriteAdditionalFiles rubySource(String rubyFile, String destPath) {
        return context -> {
            String gemName = context.settings().getGemName();
            String gemModule = context.settings().getModule();
            try {
                Path path = Paths.get(rubyFile, new String[0]);
                String relativeName = destPath + path.getFileName();
                String fileName = gemName + "/lib/" + gemName + "/" + relativeName;
                String fileContent = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
                RubyCodeWriter writer = new RubyCodeWriter(gemModule);
                ((RubyCodeWriter)((RubyCodeWriter)writer.preamble().openBlock("module $L", new Object[]{gemModule})).write(fileContent, new Object[0])).closeBlock("end", new Object[0]);
                context.fileManifest().writeFile(fileName, writer.toString());
                return Collections.singletonList(relativeName);
            }
            catch (IOException e) {
                throw new CodegenException("Error reading rubySource file: " + rubyFile, (Throwable)e);
            }
        };
    }
}

