/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.middleware.factories;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.stream.Collectors;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.ruby.codegen.ApplicationTransport;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.config.ClientConfig;
import software.amazon.smithy.ruby.codegen.middleware.Middleware;
import software.amazon.smithy.ruby.codegen.middleware.MiddlewareStackStep;

public final class SendMiddlewareFactory {
    private SendMiddlewareFactory() {
    }

    public static Middleware build(GenerationContext context) {
        ApplicationTransport transport = context.applicationTransport();
        SymbolProvider symbolProvider = context.symbolProvider();
        String stubResponsesDocumentation = "Enable response stubbing for testing. See {Hearth::ClientStubs#stub_responses}.\n";
        ClientConfig stubResponses = ClientConfig.builder().name("stub_responses").type("Boolean").rbsType("bool").defaultPrimitiveValue("false").documentation(stubResponsesDocumentation).build();
        return Middleware.builder().klass(Hearth.SEND_MIDDLEWARE).step(MiddlewareStackStep.SEND).addParam("client", transport.getTransportClient().render(context)).addParam("stubs", "@stubs").operationParams((ctx, operation) -> {
            HashMap<String, CallSite> params = new HashMap<String, CallSite>();
            params.put("stub_data_class", (CallSite)((Object)("Stubs::" + symbolProvider.toSymbol((Shape)operation).getName())));
            String errors = operation.getErrors().stream().map(error -> "Stubs::" + ctx.symbolProvider().toSymbol(ctx.model().expectShape(error)).getName()).collect(Collectors.joining(", "));
            params.put("stub_error_classes", (CallSite)((Object)("[" + errors + "]")));
            return params;
        }).addConfig(stubResponses).build();
    }
}

