/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.middleware.factories;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.ServiceIndex;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.auth.AuthScheme;
import software.amazon.smithy.ruby.codegen.config.ClientConfig;
import software.amazon.smithy.ruby.codegen.middleware.Middleware;
import software.amazon.smithy.ruby.codegen.middleware.MiddlewareStackStep;

public final class AuthMiddlewareFactory {
    private AuthMiddlewareFactory() {
    }

    public static Middleware build(GenerationContext context) {
        SymbolProvider symbolProvider = context.symbolProvider();
        Map serviceAuthSchemes = ServiceIndex.of((Model)context.model()).getAuthSchemes((ToShapeId)context.service());
        Set<AuthScheme> authSchemesSet = context.getAuthSchemes();
        HashSet identityResolversConfigSet = new HashSet();
        HashMap identityResolversMap = new HashMap();
        serviceAuthSchemes.forEach((shapeId, trait) -> {
            AuthScheme authScheme = authSchemesSet.stream().filter(s -> s.getShapeId().equals(shapeId)).findFirst().orElseThrow(() -> new IllegalStateException("No auth scheme found for " + shapeId));
            ClientConfig config = authScheme.getIdentityResolverConfig();
            if (config != null) {
                identityResolversConfigSet.add(config);
                identityResolversMap.put(authScheme.getRubyIdentityType(), config.renderGetConfigValue());
            }
        });
        ClientConfig authResolver = AuthMiddlewareFactory.buildAuthResolverConfig();
        ClientConfig authSchemes = AuthMiddlewareFactory.buildAuthSchemesConfig();
        Middleware.Builder authBuilder = Middleware.builder().klass(Hearth.AUTH_MIDDLEWARE).step(MiddlewareStackStep.SIGN).addConfig(authResolver).addConfig(authSchemes).renderAdd((writer, middleware, context1, operation) -> {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("auth_resolver", authResolver.renderGetConfigValue());
            params.put("auth_schemes", authSchemes.renderGetConfigValue());
            HashMap<String, String> authParamsMap = new HashMap<String, String>();
            authParamsMap.put("operation_name", RubyFormatter.asSymbol(symbolProvider.toSymbol((Shape)operation).getName()));
            authSchemesSet.forEach(s -> {
                Map<String, String> additionalAuthParams = s.getAdditionalAuthParams();
                additionalAuthParams.entrySet().forEach(e -> authParamsMap.put((String)e.getKey(), (String)e.getValue()));
            });
            String authParams = "Auth::Params.new(%s)".formatted(authParamsMap.entrySet().stream().map(e -> "%s: %s".formatted(e.getKey(), e.getValue())).reduce((a, b) -> a + ", " + b).orElse(""));
            params.put("auth_params", authParams);
            String staticParamsBlock = params.entrySet().stream().map(entry -> (String)entry.getKey() + ": " + (String)entry.getValue()).collect(Collectors.joining(",\n"));
            String identityResolversBlock = identityResolversMap.entrySet().stream().map(entry -> "%s => %s".formatted(entry.getKey(), entry.getValue())).collect(Collectors.joining(",\n"));
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.write("stack.use($L,", new Object[]{middleware.getKlass()})).indent()).writeInline(staticParamsBlock, new Object[0])).call(() -> {
                if (!identityResolversBlock.isEmpty()) {
                    writer.writeInline(",\n$L", new Object[]{identityResolversBlock});
                }
            })).dedent()).write("\n)", new Object[0]);
        });
        identityResolversConfigSet.forEach(authBuilder::addConfig);
        return authBuilder.build();
    }

    private static ClientConfig buildAuthResolverConfig() {
        String authResolverDocumentation = "A class that responds to a `resolve(auth_params)` method where `auth_params` is\nthe {Auth::Params} struct. For a given operation_name, the method must return an\nordered list of {%s} objects to be considered for authentication.\n".formatted(Hearth.AUTH_OPTION);
        return ClientConfig.builder().name("auth_resolver").type("Auth::Resolver").documentation(authResolverDocumentation).defaultValue("Auth::Resolver.new").build();
    }

    private static ClientConfig buildAuthSchemesConfig() {
        String authSchemesDocumentation = "An ordered list of {%s} objects that will considered when attempting to authenticate\nthe request. The first scheme that returns an Identity from its %s will be used to\nauthenticate the request.\n".formatted(Hearth.AUTH_SCHEMES + "::Base", Hearth.IDENTITY_RESOLVER);
        return ClientConfig.builder().name("auth_schemes").type("Array").documentationType("Array<" + Hearth.AUTH_SCHEMES + "::Base>").rbsType("Array[" + Hearth.AUTH_SCHEMES + "::Base]").defaultValue("Auth::SCHEMES").documentation(authSchemesDocumentation).build();
    }
}

