/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators.docs;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.BigDecimalShape;
import software.amazon.smithy.model.shapes.BigIntegerShape;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.EnumDefinition;
import software.amazon.smithy.model.traits.EnumTrait;
import software.amazon.smithy.model.traits.RequiredTrait;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class PlaceholderExampleGenerator {
    private final OperationShape operation;
    private final RubyCodeWriter writer;
    private final Set<ShapeId> visited;
    private final SymbolProvider symbolProvider;
    private final Model model;

    public PlaceholderExampleGenerator(OperationShape operation, SymbolProvider symbolProvider, Model model) {
        this.operation = operation;
        this.symbolProvider = symbolProvider;
        this.model = model;
        this.writer = new RubyCodeWriter("");
        this.visited = new HashSet<ShapeId>();
    }

    public String generate() {
        Symbol symbol = this.symbolProvider.toSymbol((Shape)this.operation);
        ShapeId inputShapeId = this.operation.getInputShape();
        Shape inputShape = this.model.expectShape(inputShapeId);
        String operationName = RubyFormatter.toSnakeCase(symbol.getName());
        if (inputShape.members().size() == 0) {
            this.writer.write("resp = client.$L()", new Object[]{operationName});
        } else {
            ((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("resp = client.$L(", new Object[]{operationName})).call(() -> {
                Iterator itr = inputShape.members().iterator();
                while (itr.hasNext()) {
                    MemberShape member = (MemberShape)itr.next();
                    Shape target = this.model.expectShape(member.getTarget());
                    String dataSetter = this.symbolProvider.toMemberName(member) + ": ";
                    String eol = itr.hasNext() ? "," : "";
                    target.accept((ShapeVisitor)new PlaceholderMember(dataSetter, member, eol, this.visited));
                }
            })).closeBlock(")", new Object[0]);
        }
        return this.writer.toString();
    }

    private final class PlaceholderMember
    extends ShapeVisitor.Default<Void> {
        private final String eol;
        private final String dataSetter;
        private final MemberShape memberShape;
        private final Set<ShapeId> visited;

        private PlaceholderMember(String dataSetter, MemberShape memberShape, String eol, Set<ShapeId> visited) {
            this.dataSetter = dataSetter;
            this.memberShape = memberShape;
            this.visited = visited;
            this.eol = memberShape.hasTrait(RequiredTrait.class) ? eol + " # required" : eol;
        }

        protected Void getDefault(Shape shape) {
            return null;
        }

        public Void blobShape(BlobShape blob) {
            PlaceholderExampleGenerator.this.writer.write("$L'$L'$L", new Object[]{this.dataSetter, this.memberShape.getMemberName(), this.eol});
            return null;
        }

        public Void byteShape(ByteShape shape) {
            PlaceholderExampleGenerator.this.writer.write("$L1$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void shortShape(ShortShape shape) {
            PlaceholderExampleGenerator.this.writer.write("$L1$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void integerShape(IntegerShape shape) {
            PlaceholderExampleGenerator.this.writer.write("$L1$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void longShape(LongShape shape) {
            PlaceholderExampleGenerator.this.writer.write("$L1$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void floatShape(FloatShape shape) {
            PlaceholderExampleGenerator.this.writer.write("$L1.0$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void doubleShape(DoubleShape shape) {
            PlaceholderExampleGenerator.this.writer.write("$L1.0$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void bigIntegerShape(BigIntegerShape shape) {
            PlaceholderExampleGenerator.this.writer.write("$L1$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void bigDecimalShape(BigDecimalShape shape) {
            PlaceholderExampleGenerator.this.writer.write("$L1.0$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void stringShape(StringShape shape) {
            if (shape.hasTrait(EnumTrait.class)) {
                EnumTrait enumTrait = (EnumTrait)shape.expectTrait(EnumTrait.class);
                String defaultValue = ((EnumDefinition)enumTrait.getValues().get(0)).getValue();
                Object accepts = enumTrait.getEnumDefinitionValues().stream().map(value -> "\"" + value + "\"").collect(Collectors.joining(", "));
                accepts = this.memberShape.hasTrait(RequiredTrait.class) ? " - accepts [" + (String)accepts + "]" : " # accepts [" + (String)accepts + "]";
                PlaceholderExampleGenerator.this.writer.write("$L'$L'$L", new Object[]{this.dataSetter, defaultValue, this.eol + (String)accepts});
            } else {
                PlaceholderExampleGenerator.this.writer.write("$L'$L'$L", new Object[]{this.dataSetter, this.memberShape.getMemberName(), this.eol});
            }
            return null;
        }

        public Void timestampShape(TimestampShape shape) {
            PlaceholderExampleGenerator.this.writer.write("$LTime.now$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void booleanShape(BooleanShape shape) {
            PlaceholderExampleGenerator.this.writer.write("$Lfalse$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void structureShape(StructureShape shape) {
            if (!this.visited.add(shape.getId())) {
                return null;
            }
            if (shape.members().size() == 0) {
                PlaceholderExampleGenerator.this.writer.write("$L{ }$L", new Object[]{this.dataSetter, this.eol});
            } else {
                PlaceholderExampleGenerator.this.writer.openBlock("$L{", new Object[]{this.dataSetter});
                Iterator itr = shape.members().iterator();
                while (itr.hasNext()) {
                    MemberShape member = (MemberShape)itr.next();
                    Shape target = PlaceholderExampleGenerator.this.model.expectShape(member.getTarget());
                    String dataSetter = PlaceholderExampleGenerator.this.symbolProvider.toMemberName(member) + ": ";
                    String eol = itr.hasNext() ? "," : "";
                    target.accept((ShapeVisitor)new PlaceholderMember(dataSetter, member, eol, this.visited));
                }
                PlaceholderExampleGenerator.this.writer.closeBlock("}$L", new Object[]{this.eol});
            }
            return null;
        }

        public Void listShape(ListShape shape) {
            if (!this.visited.add(shape.getId())) {
                return null;
            }
            Shape target = PlaceholderExampleGenerator.this.model.expectShape(shape.getMember().getTarget());
            if (!this.visited.contains(target.getId())) {
                PlaceholderExampleGenerator.this.writer.openBlock("$L[", new Object[]{this.dataSetter});
                target.accept((ShapeVisitor)new PlaceholderMember("", shape.getMember(), "", this.visited));
                PlaceholderExampleGenerator.this.writer.closeBlock("]$L", new Object[]{this.eol});
            }
            return null;
        }

        public Void mapShape(MapShape shape) {
            if (!this.visited.add(shape.getId())) {
                return null;
            }
            Shape target = PlaceholderExampleGenerator.this.model.expectShape(shape.getValue().getTarget());
            if (!this.visited.contains(target.getId())) {
                String setter = "'" + shape.getKey().getMemberName() + "' => ";
                PlaceholderExampleGenerator.this.writer.openBlock("$L{", new Object[]{this.dataSetter});
                target.accept((ShapeVisitor)new PlaceholderMember(setter, shape.getValue(), "", this.visited));
                PlaceholderExampleGenerator.this.writer.closeBlock("}$L", new Object[]{this.eol});
            }
            return null;
        }

        public Void unionShape(UnionShape shape) {
            if (!this.visited.add(shape.getId())) {
                return null;
            }
            PlaceholderExampleGenerator.this.writer.openBlock("$L{", new Object[]{this.dataSetter});
            PlaceholderExampleGenerator.this.writer.write("# One of: ", new Object[0]);
            Iterator itr = shape.members().iterator();
            while (itr.hasNext()) {
                MemberShape member = (MemberShape)itr.next();
                Shape target = PlaceholderExampleGenerator.this.model.expectShape(member.getTarget());
                String dataSetter = RubyFormatter.toSnakeCase(PlaceholderExampleGenerator.this.symbolProvider.toMemberName(member)) + ": ";
                String eol = itr.hasNext() ? "," : "";
                target.accept((ShapeVisitor)new PlaceholderMember(dataSetter, member, eol, this.visited));
            }
            PlaceholderExampleGenerator.this.writer.closeBlock("}$L", new Object[]{this.eol});
            return null;
        }

        public Void documentShape(DocumentShape shape) {
            if (!this.visited.add(shape.getId())) {
                return null;
            }
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)PlaceholderExampleGenerator.this.writer.openBlock("$L{", new Object[]{this.dataSetter})).write("'nil' => nil,", new Object[0])).write("'number' => 123.0,", new Object[0])).write("'string' => 'value',", new Object[0])).write("'boolean' => true,", new Object[0])).write("'array' => [],", new Object[0])).write("'map' => {}", new Object[0])).closeBlock("}$L", new Object[]{this.eol});
            return null;
        }
    }
}

