/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.traits.HttpHeaderTrait;
import software.amazon.smithy.model.traits.HttpPayloadTrait;
import software.amazon.smithy.model.traits.HttpPrefixHeadersTrait;
import software.amazon.smithy.model.traits.HttpResponseCodeTrait;
import software.amazon.smithy.model.traits.MediaTypeTrait;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyImportContainer;
import software.amazon.smithy.ruby.codegen.generators.ParserGeneratorBase;
import software.amazon.smithy.ruby.codegen.util.TimestampFormat;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public abstract class RestParserGeneratorBase
extends ParserGeneratorBase {
    private static final Logger LOGGER = Logger.getLogger(RestParserGeneratorBase.class.getName());

    public RestParserGeneratorBase(GenerationContext context) {
        super(context);
    }

    protected abstract void renderPayloadBodyParser(Shape var1, MemberShape var2, Shape var3);

    protected abstract void renderBodyParser(Shape var1);

    @Override
    protected void renderOperationParseMethod(OperationShape operation, Shape outputShape) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("def self.parse(http_resp)", new Object[0])).write("data = $T.new", new Object[]{this.context.symbolProvider().toSymbol(outputShape)})).call(() -> this.renderHeaderParsers(outputShape))).call(() -> this.renderPrefixHeaderParsers(outputShape))).call(() -> this.renderResponseCodeParser(outputShape))).call(() -> this.renderOperationBodyParser(outputShape))).write("data", new Object[0])).closeBlock("end", new Object[0]);
        LOGGER.finer("Generated parse method for " + operation.getId().getName());
    }

    @Override
    protected void renderErrorParseMethod(Shape s) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("def self.parse(http_resp)", new Object[0])).write("data = $T.new", new Object[]{this.context.symbolProvider().toSymbol(s)})).call(() -> this.renderHeaderParsers(s))).call(() -> this.renderPrefixHeaderParsers(s))).call(() -> this.renderOperationBodyParser(s))).write("data", new Object[0])).closeBlock("end", new Object[0]);
        LOGGER.finer("Generated Error parser for " + s.getId().getName());
    }

    protected void renderHeaderParsers(Shape outputShape) {
        List headerMembers = outputShape.members().stream().filter(m -> m.hasTrait(HttpHeaderTrait.class)).collect(Collectors.toList());
        for (MemberShape m2 : headerMembers) {
            HttpHeaderTrait headerTrait = (HttpHeaderTrait)m2.expectTrait(HttpHeaderTrait.class);
            String symbolName = this.symbolProvider.toMemberName(m2);
            String dataSetter = "data." + symbolName + " = ";
            String valueGetter = "http_resp.headers['" + headerTrait.getValue() + "']";
            this.model.expectShape(m2.getTarget()).accept((ShapeVisitor)new HeaderDeserializer(m2, dataSetter, valueGetter));
            LOGGER.finest("Generated header parser for " + m2.getMemberName());
        }
    }

    protected void renderPrefixHeaderParsers(Shape outputShape) {
        List headerMembers = outputShape.members().stream().filter(m -> m.hasTrait(HttpPrefixHeadersTrait.class)).collect(Collectors.toList());
        for (MemberShape m2 : headerMembers) {
            HttpPrefixHeadersTrait headerTrait = (HttpPrefixHeadersTrait)m2.expectTrait(HttpPrefixHeadersTrait.class);
            String prefix = headerTrait.getValue();
            MapShape targetShape = (MapShape)this.model.expectShape(m2.getTarget(), MapShape.class);
            Shape valueShape = this.model.expectShape(targetShape.getValue().getTarget());
            String symbolName = this.symbolProvider.toMemberName(m2);
            String dataSetter = "data." + symbolName + "[key.delete_prefix('" + prefix + "')] = ";
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write("data.$L = {}", new Object[]{symbolName})).openBlock("http_resp.headers.each do |key, value|", new Object[0])).openBlock("if key.start_with?('$L')", new Object[]{prefix})).call(() -> valueShape.accept((ShapeVisitor)new HeaderDeserializer(m2, dataSetter, "value")))).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
            LOGGER.finest("Generated prefix header parser for " + m2.getMemberName());
        }
    }

    protected void renderResponseCodeParser(Shape outputShape) {
        List responseCodeMembers = outputShape.members().stream().filter(m -> m.hasTrait(HttpResponseCodeTrait.class)).collect(Collectors.toList());
        if (responseCodeMembers.size() == 1) {
            MemberShape responseCodeMember = (MemberShape)responseCodeMembers.get(0);
            this.writer.write("data.$L = http_resp.status", new Object[]{this.symbolProvider.toMemberName(responseCodeMember)});
            LOGGER.finest("Generated response code parser for " + responseCodeMember.getMemberName());
        }
    }

    protected void renderOperationBodyParser(Shape outputShape) {
        List httpPayloadMembers = outputShape.members().stream().filter(m -> m.hasTrait(HttpPayloadTrait.class)).collect(Collectors.toList());
        if (httpPayloadMembers.size() == 0) {
            this.renderBodyParser(outputShape);
        } else if (httpPayloadMembers.size() == 1) {
            MemberShape payloadMember = (MemberShape)httpPayloadMembers.get(0);
            Shape target = this.model.expectShape(payloadMember.getTarget());
            this.renderPayloadBodyParser(outputShape, payloadMember, target);
        }
    }

    private class HeaderDeserializer
    extends ShapeVisitor.Default<Void> {
        private final String valueGetter;
        private final String dataSetter;
        private final MemberShape memberShape;

        HeaderDeserializer(MemberShape memberShape, String dataSetter, String valueGetter) {
            this.valueGetter = valueGetter;
            this.dataSetter = dataSetter;
            this.memberShape = memberShape;
        }

        protected Void getDefault(Shape shape) {
            RestParserGeneratorBase.this.writer.write("$L$L", new Object[]{this.dataSetter, this.valueGetter});
            return null;
        }

        private void rubyFloat() {
            RestParserGeneratorBase.this.writer.write("$1L$3T.deserialize($2L) unless $2L.nil?", new Object[]{this.dataSetter, this.valueGetter, Hearth.NUMBER_HELPER});
        }

        public Void doubleShape(DoubleShape shape) {
            this.rubyFloat();
            return null;
        }

        public Void floatShape(FloatShape shape) {
            this.rubyFloat();
            return null;
        }

        public Void booleanShape(BooleanShape shape) {
            RestParserGeneratorBase.this.writer.write("$1L$2L == 'true' unless $2L.nil?", new Object[]{this.dataSetter, this.valueGetter});
            return null;
        }

        public Void integerShape(IntegerShape shape) {
            RestParserGeneratorBase.this.writer.write("$1L$2L.to_i unless $2L.nil?", new Object[]{this.dataSetter, this.valueGetter});
            return null;
        }

        public Void byteShape(ByteShape shape) {
            RestParserGeneratorBase.this.writer.write("$1L$2L.to_i unless $2L.nil?", new Object[]{this.dataSetter, this.valueGetter});
            return null;
        }

        public Void longShape(LongShape shape) {
            RestParserGeneratorBase.this.writer.write("$1L$2L.to_i unless $2L.nil?", new Object[]{this.dataSetter, this.valueGetter});
            return null;
        }

        public Void shortShape(ShortShape shape) {
            RestParserGeneratorBase.this.writer.write("$1L$2L.to_i unless $2L.nil?", new Object[]{this.dataSetter, this.valueGetter});
            return null;
        }

        public Void stringShape(StringShape shape) {
            if (shape.hasTrait(MediaTypeTrait.class)) {
                RestParserGeneratorBase.this.writer.write("$1L$3T::decode64($2L).strip unless $2L.nil?", new Object[]{this.dataSetter, this.valueGetter, RubyImportContainer.BASE64});
            } else {
                RestParserGeneratorBase.this.writer.write("$1L$2L", new Object[]{this.dataSetter, this.valueGetter});
            }
            return null;
        }

        public Void timestampShape(TimestampShape shape) {
            RestParserGeneratorBase.this.writer.write("$L$L if $L", new Object[]{this.dataSetter, TimestampFormat.parseTimestamp(shape, this.memberShape, this.valueGetter, TimestampFormatTrait.Format.DATE_TIME), this.valueGetter});
            return null;
        }

        public Void listShape(ListShape shape) {
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)RestParserGeneratorBase.this.writer.openBlock("unless $1L.nil? || $1L.empty?", new Object[]{this.valueGetter})).write("$1L$2L", new Object[]{this.dataSetter, this.valueGetter})).indent()).write(".split(', ')", new Object[0])).call(() -> RestParserGeneratorBase.this.model.expectShape(shape.getMember().getTarget()).accept((ShapeVisitor)new HeaderListMemberDeserializer(shape.getMember())))).dedent()).closeBlock("end", new Object[0]);
            return null;
        }
    }

    private class HeaderListMemberDeserializer
    extends ShapeVisitor.Default<Void> {
        private final MemberShape memberShape;

        HeaderListMemberDeserializer(MemberShape memberShape) {
            this.memberShape = memberShape;
        }

        protected Void getDefault(Shape shape) {
            return null;
        }

        public Void stringShape(StringShape shape) {
            RestParserGeneratorBase.this.writer.write(".map { |s| s.to_s }", new Object[0]);
            return null;
        }

        public Void booleanShape(BooleanShape shape) {
            RestParserGeneratorBase.this.writer.write(".map { |s| s == 'true' }", new Object[0]);
            return null;
        }

        public Void integerShape(IntegerShape shape) {
            RestParserGeneratorBase.this.writer.write(".map { |s| s.to_i }", new Object[0]);
            return null;
        }

        public Void timestampShape(TimestampShape shape) {
            RestParserGeneratorBase.this.writer.write(".map { |s| $L }", new Object[]{TimestampFormat.parseTimestamp(shape, this.memberShape, "s", TimestampFormatTrait.Format.HTTP_DATE)});
            return null;
        }
    }
}

