/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.HttpHeaderTrait;
import software.amazon.smithy.model.traits.HttpLabelTrait;
import software.amazon.smithy.model.traits.HttpPayloadTrait;
import software.amazon.smithy.model.traits.HttpPrefixHeadersTrait;
import software.amazon.smithy.model.traits.HttpQueryParamsTrait;
import software.amazon.smithy.model.traits.HttpQueryTrait;
import software.amazon.smithy.model.traits.HttpTrait;
import software.amazon.smithy.model.traits.MediaTypeTrait;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyImportContainer;
import software.amazon.smithy.ruby.codegen.generators.BuilderGeneratorBase;
import software.amazon.smithy.ruby.codegen.util.TimestampFormat;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public abstract class RestBuilderGeneratorBase
extends BuilderGeneratorBase {
    private static final Logger LOGGER = Logger.getLogger(RestBuilderGeneratorBase.class.getName());

    public RestBuilderGeneratorBase(GenerationContext context) {
        super(context);
    }

    protected abstract void renderPayloadBodyBuilder(OperationShape var1, Shape var2, MemberShape var3, Shape var4);

    protected abstract void renderBodyBuilder(OperationShape var1, Shape var2);

    @Override
    protected void renderOperationBuildMethod(OperationShape operation, Shape inputShape) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("def self.build(http_req, input:)", new Object[0])).write("http_req.http_method = '$L'", new Object[]{this.getHttpMethod(operation)})).call(() -> this.renderUriBuilder(operation, inputShape))).call(() -> this.renderQueryInputBuilder(inputShape))).call(() -> this.renderOperationBodyBuilder(operation, inputShape))).call(() -> this.renderHeadersBuilder(inputShape))).call(() -> this.renderPrefixHeadersBuilder(inputShape))).closeBlock("end", new Object[0]);
        LOGGER.finer("Generated operation build method for: " + operation.getId().getName());
    }

    protected String getHttpMethod(OperationShape operation) {
        HttpTrait httpTrait = (HttpTrait)operation.expectTrait(HttpTrait.class);
        return httpTrait.getMethod();
    }

    protected void renderQueryInputBuilder(Shape inputShape) {
        List queryParamsMembers = inputShape.members().stream().filter(m -> m.hasTrait(HttpQueryParamsTrait.class)).collect(Collectors.toList());
        this.writer.write("params = $T.new", new Object[]{Hearth.QUERY_PARAM_LIST});
        for (MemberShape m2 : queryParamsMembers) {
            String inputGetter = "input[:" + this.symbolProvider.toMemberName(m2) + "]";
            MapShape queryParamMap = (MapShape)this.model.expectShape(m2.getTarget(), MapShape.class);
            Shape target = this.model.expectShape(queryParamMap.getValue().getTarget());
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("unless $1L.nil? || $1L.empty?", new Object[]{inputGetter})).openBlock("$1L.each do |k, v|", new Object[]{inputGetter})).call(() -> target.accept((ShapeVisitor)new QueryMemberSerializer(queryParamMap.getValue(), "params[k] = ", "v")))).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
            LOGGER.finest("Generated query params builder for " + m2.getMemberName());
        }
        List queryMembers = inputShape.members().stream().filter(m -> m.hasTrait(HttpQueryTrait.class)).collect(Collectors.toList());
        for (MemberShape m3 : queryMembers) {
            HttpQueryTrait queryTrait = (HttpQueryTrait)m3.expectTrait(HttpQueryTrait.class);
            String inputGetter = "input[:" + this.symbolProvider.toMemberName(m3) + "]";
            Shape target = this.model.expectShape(m3.getTarget());
            String setter = this.writer.format("params['$L'] = ", new Object[]{queryTrait.getValue()});
            target.accept((ShapeVisitor)new QueryMemberSerializer(m3, setter, inputGetter));
            LOGGER.finest("Generated query input builder for " + m3.getMemberName());
        }
        this.writer.write("http_req.append_query_param_list(params)", new Object[0]);
    }

    protected void renderHeadersBuilder(Shape inputShape) {
        List headerMembers = inputShape.members().stream().filter(m -> m.hasTrait(HttpHeaderTrait.class)).collect(Collectors.toList());
        for (MemberShape m2 : headerMembers) {
            HttpHeaderTrait headerTrait = (HttpHeaderTrait)m2.expectTrait(HttpHeaderTrait.class);
            String symbolName = ":" + this.symbolProvider.toMemberName(m2);
            String headerSetter = "http_req.headers['" + headerTrait.getValue() + "'] = ";
            String valueGetter = "input[" + symbolName + "]";
            this.model.expectShape(m2.getTarget()).accept((ShapeVisitor)new HeaderSerializer(m2, headerSetter, valueGetter));
            LOGGER.finest("Generated header builder for " + m2.getMemberName());
        }
    }

    protected void renderPrefixHeadersBuilder(Shape inputShape) {
        List headerMembers = inputShape.members().stream().filter(m -> m.hasTrait(HttpPrefixHeadersTrait.class)).collect(Collectors.toList());
        for (MemberShape m2 : headerMembers) {
            HttpPrefixHeadersTrait headerTrait = (HttpPrefixHeadersTrait)m2.expectTrait(HttpPrefixHeadersTrait.class);
            String prefix = headerTrait.getValue();
            MapShape targetShape = (MapShape)this.model.expectShape(m2.getTarget(), MapShape.class);
            Shape valueShape = this.model.expectShape(targetShape.getValue().getTarget());
            String symbolName = ":" + this.symbolProvider.toMemberName(m2);
            String headerSetter = "http_req.headers[\"" + prefix + "#{key}\"] = ";
            ((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("input[$L]&.each do |key, value|", new Object[]{symbolName})).call(() -> valueShape.accept((ShapeVisitor)new HeaderSerializer(m2, headerSetter, "value")))).closeBlock("end", new Object[0]);
            LOGGER.finest("Generated prefix header builder for " + m2.getMemberName());
        }
    }

    protected void renderUriBuilder(OperationShape operation, Shape inputShape) {
        List labelMembers;
        String uri = this.getHttpUri(operation);
        String[] uriParts = uri.split("[?]");
        if (uriParts.length > 1) {
            uri = uriParts[0];
            ((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("CGI.parse('$L').each do |k,v|", new Object[]{uriParts[1]})).write("v.each { |q_v| http_req.append_query_param(k, q_v) }", new Object[0])).closeBlock("end", new Object[0]);
        }
        if ((labelMembers = inputShape.members().stream().filter(m -> m.hasTrait(HttpLabelTrait.class)).collect(Collectors.toList())).size() > 0) {
            Optional<Object> greedyLabel = Optional.empty();
            Matcher greedyMatch = Pattern.compile("[{]([a-zA-Z0-9_]+)[+][}]").matcher(uri);
            if (greedyMatch.find()) {
                greedyLabel = Optional.of(greedyMatch.group(1));
                uri = greedyMatch.replaceAll("%<$1>s");
            }
            String formatUri = uri.replaceAll("[{]([a-zA-Z0-9_]+)[}]", "%<$1>s");
            StringBuffer formatArgs = new StringBuffer();
            for (MemberShape m2 : labelMembers) {
                Shape target = this.model.expectShape(m2.getTarget());
                String getter = (String)target.accept((ShapeVisitor)new LabelMemberSerializer(m2));
                if (greedyLabel.isPresent() && ((String)greedyLabel.get()).equals(m2.getMemberName())) {
                    formatArgs.append(",\n  " + m2.getMemberName() + ": (" + getter + ").split('/').map { |s| Hearth::HTTP.uri_escape(s) }.join('/')");
                } else {
                    formatArgs.append(",\n  " + m2.getMemberName() + ": Hearth::HTTP.uri_escape(" + getter + ")");
                }
                ((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("if $1L.empty?", new Object[]{getter})).write("raise ArgumentError, \"HTTP label :$L cannot be empty.\"", new Object[]{this.symbolProvider.toMemberName(m2)})).closeBlock("end", new Object[0]);
                LOGGER.finest("Generated label for " + m2.getMemberName());
            }
            this.writer.openBlock("http_req.append_path(format(", new Object[0]);
            this.writer.write("  '$L'$L\n)", new Object[]{formatUri, formatArgs.toString()});
            this.writer.closeBlock(")", new Object[0]);
        } else {
            this.writer.write("http_req.append_path('$L')", new Object[]{uri});
        }
    }

    protected String getHttpUri(OperationShape operation) {
        HttpTrait httpTrait = (HttpTrait)operation.expectTrait(HttpTrait.class);
        return httpTrait.getUri().toString();
    }

    protected void renderOperationBodyBuilder(OperationShape operation, Shape inputShape) {
        this.generatedBuilders.add(inputShape.getId());
        boolean serializeBody = inputShape.members().stream().anyMatch(m -> !m.hasTrait(HttpLabelTrait.class) && !m.hasTrait(HttpQueryTrait.class) && !m.hasTrait(HttpHeaderTrait.class) && !m.hasTrait(HttpPrefixHeadersTrait.class) && !m.hasTrait(HttpQueryParamsTrait.class));
        if (serializeBody) {
            Optional<MemberShape> httpPayloadMember = inputShape.members().stream().filter(m -> m.hasTrait(HttpPayloadTrait.class)).findFirst();
            if (httpPayloadMember.isEmpty()) {
                this.renderBodyBuilder(operation, inputShape);
            } else {
                Shape target = this.model.expectShape(httpPayloadMember.get().getTarget());
                this.renderPayloadBodyBuilder(operation, inputShape, httpPayloadMember.get(), target);
            }
        }
    }

    protected class QueryMemberSerializer
    extends ShapeVisitor.Default<Void> {
        private final String inputGetter;
        private final String setter;
        private final MemberShape memberShape;

        QueryMemberSerializer(MemberShape memberShape, String setter, String inputGetter) {
            this.inputGetter = inputGetter;
            this.setter = setter;
            this.memberShape = memberShape;
        }

        protected Void getDefault(Shape shape) {
            RestBuilderGeneratorBase.this.writer.write("$1L$2L.to_s unless $2L.nil?", new Object[]{this.setter, this.inputGetter});
            return null;
        }

        public Void timestampShape(TimestampShape shape) {
            RestBuilderGeneratorBase.this.writer.write("$L$L unless $L.nil?", new Object[]{this.setter, TimestampFormat.serializeTimestamp(shape, this.memberShape, this.inputGetter, TimestampFormatTrait.Format.DATE_TIME, false), this.inputGetter});
            return null;
        }

        public Void listShape(ListShape shape) {
            Shape target = RestBuilderGeneratorBase.this.model.expectShape(shape.getMember().getTarget());
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)RestBuilderGeneratorBase.this.writer.openBlock("unless $1L.nil? || $1L.empty?", new Object[]{this.inputGetter})).openBlock("$1L$2L.map do |value|", new Object[]{this.setter, this.inputGetter})).call(() -> target.accept((ShapeVisitor)new QueryMemberSerializer(shape.getMember(), "", "value")))).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
            return null;
        }

        public Void mapShape(MapShape shape) {
            return null;
        }

        public Void structureShape(StructureShape shape) {
            return null;
        }

        public Void unionShape(UnionShape shape) {
            return null;
        }
    }

    protected class HeaderSerializer
    extends ShapeVisitor.Default<Void> {
        private final String inputGetter;
        private final String dataSetter;
        private final MemberShape memberShape;

        HeaderSerializer(MemberShape memberShape, String dataSetter, String inputGetter) {
            this.inputGetter = inputGetter;
            this.dataSetter = dataSetter;
            this.memberShape = memberShape;
        }

        protected Void getDefault(Shape shape) {
            RestBuilderGeneratorBase.this.writer.write("$1L$2L.to_s unless $2L.nil?", new Object[]{this.dataSetter, this.inputGetter});
            return null;
        }

        private void rubyFloat() {
            RestBuilderGeneratorBase.this.writer.write("$1L$3T.serialize($2L) unless $2L.nil?", new Object[]{this.dataSetter, this.inputGetter, Hearth.NUMBER_HELPER});
        }

        public Void doubleShape(DoubleShape shape) {
            this.rubyFloat();
            return null;
        }

        public Void floatShape(FloatShape shape) {
            this.rubyFloat();
            return null;
        }

        public Void stringShape(StringShape shape) {
            if (shape.hasTrait(MediaTypeTrait.class)) {
                RestBuilderGeneratorBase.this.writer.write("$1L$3T::encode64($2L).strip unless $2L.nil? || $2L.empty?", new Object[]{this.dataSetter, this.inputGetter, RubyImportContainer.BASE64});
            } else {
                RestBuilderGeneratorBase.this.writer.write("$1L$2L unless $2L.nil? || $2L.empty?", new Object[]{this.dataSetter, this.inputGetter});
            }
            return null;
        }

        public Void timestampShape(TimestampShape shape) {
            RestBuilderGeneratorBase.this.writer.write("$1L$2L unless $3L.nil?", new Object[]{this.dataSetter, TimestampFormat.serializeTimestamp(shape, this.memberShape, this.inputGetter, TimestampFormatTrait.Format.HTTP_DATE, false), this.inputGetter});
            return null;
        }

        public Void listShape(ListShape shape) {
            RestBuilderGeneratorBase.this.writer.write("$1L$2L unless $2L.nil? || $2L.empty?", new Object[]{this.dataSetter, this.inputGetter});
            return null;
        }

        public Void mapShape(MapShape shape) {
            return null;
        }

        public Void structureShape(StructureShape shape) {
            return null;
        }

        public Void unionShape(UnionShape shape) {
            return null;
        }
    }

    protected class LabelMemberSerializer
    extends ShapeVisitor.Default<String> {
        private final MemberShape memberShape;

        LabelMemberSerializer(MemberShape memberShape) {
            this.memberShape = memberShape;
        }

        protected String getDefault(Shape shape) {
            String symbolName = ":" + RestBuilderGeneratorBase.this.symbolProvider.toMemberName(this.memberShape);
            return "input[" + symbolName + "].to_s";
        }

        public String timestampShape(TimestampShape shape) {
            String symbolName = ":" + RestBuilderGeneratorBase.this.symbolProvider.toMemberName(this.memberShape);
            return TimestampFormat.serializeTimestamp(shape, this.memberShape, "input[" + symbolName + "]", TimestampFormatTrait.Format.DATE_TIME, true);
        }
    }
}

