/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.IdempotencyTokenTrait;
import software.amazon.smithy.model.traits.StreamingTrait;
import software.amazon.smithy.protocoltests.traits.AppliesTo;
import software.amazon.smithy.protocoltests.traits.HttpRequestTestCase;
import software.amazon.smithy.protocoltests.traits.HttpRequestTestsTrait;
import software.amazon.smithy.protocoltests.traits.HttpResponseTestCase;
import software.amazon.smithy.protocoltests.traits.HttpResponseTestsTrait;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyDependency;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.RubyImportContainer;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.traits.SkipTest;
import software.amazon.smithy.ruby.codegen.traits.SkipTestsTrait;
import software.amazon.smithy.ruby.codegen.util.ParamsToHash;
import software.amazon.smithy.ruby.codegen.util.Streaming;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class HttpProtocolTestGenerator {
    private static final Logger LOGGER = Logger.getLogger(HttpProtocolTestGenerator.class.getName());
    private final GenerationContext context;
    private final RubySettings settings;
    private final Model model;
    private final RubyCodeWriter writer;
    private final SymbolProvider symbolProvider;

    public HttpProtocolTestGenerator(GenerationContext context) {
        this.context = context;
        this.settings = context.settings();
        this.model = context.model();
        this.writer = new RubyCodeWriter(context.settings().getModule());
        this.symbolProvider = context.symbolProvider();
    }

    public void render() {
        FileManifest fileManifest = this.context.fileManifest();
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.preamble().includeRequires().write("require '$L'\n", new Object[]{this.settings.getGemName()})).write("", new Object[0])).openBlock("module $L", new Object[]{this.settings.getModule()})).openBlock("describe Client do", new Object[0])).openBlock("let(:client) do", new Object[0])).openBlock("Client.new(", new Object[0])).write("stub_responses: true,", new Object[0])).write("validate_input: false,", new Object[0])).write("endpoint: 'http://127.0.0.1',", new Object[0])).write("retry_strategy: Hearth::Retry::Standard.new(max_attempts: 0)", new Object[0])).closeBlock(")", new Object[0])).closeBlock("end", new Object[0])).call(() -> this.renderTests())).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
        String fileName = this.settings.getGemName() + "/spec/protocol_spec.rb";
        fileManifest.writeFile(fileName, this.writer.toString());
        LOGGER.fine("Wrote protocol tests to " + fileName);
    }

    private void renderTests() {
        TopDownIndex topDownIndex = TopDownIndex.of((Model)this.model);
        this.writer.write("", new Object[0]);
        topDownIndex.getContainedOperations((ToShapeId)this.context.service()).stream().forEach(operation -> {
            String operationName = RubyFormatter.toSnakeCase(this.symbolProvider.toSymbol((Shape)operation).getName());
            this.writer.openBlock("describe '#$L' do", new Object[]{operationName});
            operation.getTrait(HttpRequestTestsTrait.class).ifPresent(requestTests -> this.renderRequestTests((OperationShape)operation, (HttpRequestTestsTrait)requestTests));
            this.writer.write("", new Object[0]);
            operation.getTrait(HttpResponseTestsTrait.class).ifPresent(responseTests -> {
                this.renderResponseTests((OperationShape)operation, (HttpResponseTestsTrait)responseTests);
                this.renderResponseStubberTests((OperationShape)operation, (HttpResponseTestsTrait)responseTests);
            });
            this.renderErrorTests((OperationShape)operation);
            this.writer.closeBlock("\nend\n", new Object[0]);
        });
    }

    private void renderResponseTests(OperationShape operation, HttpResponseTestsTrait responseTests) {
        String operationName = RubyFormatter.toSnakeCase(this.symbolProvider.toSymbol((Shape)operation).getName());
        Shape outputShape = this.model.expectShape(operation.getOutputShape());
        this.writer.openBlock("\ndescribe 'responses' do", new Object[0]);
        responseTests.getTestCases().forEach(testCase -> {
            if (testCase.getAppliesTo().isPresent() && ((AppliesTo)testCase.getAppliesTo().get()).toString().equals("server")) {
                return;
            }
            String documentation = testCase.getDocumentation().orElse("");
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write("", new Object[0])).writeDocstring(documentation).openBlock("it '$L'$L do", new Object[]{testCase.getId(), this.skipTest(operation, testCase.getId(), "response")})).call(() -> this.renderResponseStubResponse(operation, (HttpResponseTestCase)testCase))).call(() -> this.renderSkipBuild(operation))).write("output = client.$L({})", new Object[]{operationName})).call(() -> {
                if (Streaming.isStreaming(this.model, outputShape)) {
                    this.renderStreamingParamReader(outputShape);
                }
            })).write("expect(output.data.to_h).to eq($L)", new Object[]{this.getRubyHashFromParams(outputShape, testCase.getParams())})).closeBlock("end", new Object[0]);
            LOGGER.finer("Generated protocol response test for operation " + operationName + " test: " + testCase.getId());
        });
        this.writer.closeBlock("\nend", new Object[0]);
    }

    private void renderResponseStubberTests(OperationShape operation, HttpResponseTestsTrait responseTests) {
        String operationName = RubyFormatter.toSnakeCase(this.symbolProvider.toSymbol((Shape)operation).getName());
        Shape outputShape = this.model.expectShape(operation.getOutputShape());
        this.writer.openBlock("\ndescribe 'stubs' do", new Object[0]);
        responseTests.getTestCases().forEach(testCase -> {
            if (testCase.getAppliesTo().isPresent() && ((AppliesTo)testCase.getAppliesTo().get()).toString().equals("server")) {
                return;
            }
            String documentation = testCase.getDocumentation().orElse("");
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write("", new Object[0])).writeDocstring(documentation).openBlock("it 'stubs $L'$L do", new Object[]{testCase.getId(), this.skipTest(operation, testCase.getId(), "response")})).call(() -> this.renderResponseStubInterceptor((HttpResponseTestCase)testCase))).write("interceptor = $T.new(read_after_transmit: proc)", new Object[]{Hearth.INTERCEPTOR})).call(() -> this.renderSkipBuild(operation))).write("client.stub_responses(:$L, data: $L)", new Object[]{operationName, this.getRubyHashFromParams(outputShape, testCase.getParams())})).write("output = client.$L({}, interceptors: [interceptor])", new Object[]{operationName})).call(() -> {
                if (Streaming.isStreaming(this.model, outputShape)) {
                    this.renderStreamingParamReader(outputShape);
                }
            })).write("expect(output.data.to_h).to eq($L)", new Object[]{this.getRubyHashFromParams(outputShape, testCase.getParams())})).closeBlock("end", new Object[0]);
            LOGGER.finer("Generated protocol stubs test for operation " + operationName + " test: " + testCase.getId());
        });
        this.writer.closeBlock("\nend", new Object[0]);
    }

    private void renderRequestTests(OperationShape operation, HttpRequestTestsTrait requestTests) {
        String operationName = RubyFormatter.toSnakeCase(this.symbolProvider.toSymbol((Shape)operation).getName());
        Shape inputShape = this.model.expectShape(operation.getInputShape());
        this.writer.openBlock("\ndescribe 'requests' do", new Object[0]);
        requestTests.getTestCases().forEach(testCase -> {
            if (testCase.getAppliesTo().isPresent() && ((AppliesTo)testCase.getAppliesTo().get()).toString().equals("server")) {
                return;
            }
            String documentation = testCase.getDocumentation().orElse("");
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write("", new Object[0])).writeDocstring(documentation).openBlock("it '$L'$L do", new Object[]{testCase.getId(), this.skipTest(operation, testCase.getId(), "request")})).call(() -> {
                if (inputShape.members().stream().anyMatch(m -> m.hasTrait(IdempotencyTokenTrait.class))) {
                    this.writer.write("allow(SecureRandom).to receive(:uuid).and_return('00000000-0000-4000-8000-000000000000')", new Object[0]);
                }
            })).call(() -> this.renderRequestInterceptor((HttpRequestTestCase)testCase))).write("interceptor = $T.new(read_before_transmit: proc)", new Object[]{Hearth.INTERCEPTOR})).write("opts = {interceptors: [interceptor]}", new Object[0])).call(() -> {
                if (testCase.getHost().isPresent()) {
                    this.writer.write("opts[:endpoint] = 'http://$L'", new Object[]{testCase.getHost().get()});
                }
            })).write("client.$L($L, **opts)", new Object[]{operationName, this.getRubyHashFromParams(inputShape, testCase.getParams())})).closeBlock("end", new Object[0]);
            LOGGER.finer("Generated protocol request test for operation " + operationName + " test: " + testCase.getId());
        });
        this.writer.closeBlock("\nend", new Object[0]);
    }

    private String skipTest(OperationShape operation, String testCaseId, String testType) {
        Optional<SkipTest> skipTest;
        if (operation.hasTrait(SkipTestsTrait.class) && (skipTest = ((SkipTestsTrait)operation.expectTrait(SkipTestsTrait.class)).skipTest(testCaseId, testType)).isPresent() && skipTest.get().getId().equals(testCaseId)) {
            if (skipTest.get().getReason().isPresent()) {
                return this.writer.format(", skip: '$L' ", new Object[]{skipTest.get().getReason().get()});
            }
            return ", skip: true ";
        }
        return "";
    }

    private void renderErrorTests(OperationShape operation) {
        String operationName = RubyFormatter.toSnakeCase(operation.getId().getName());
        for (StructureShape error : OperationIndex.of((Model)this.model).getErrors((ToShapeId)operation)) {
            error.getTrait(HttpResponseTestsTrait.class).ifPresent(responseTests -> {
                this.writer.openBlock("\ndescribe '$L error' do", new Object[]{error.getId().getName()});
                responseTests.getTestCases().forEach(testCase -> {
                    if (testCase.getAppliesTo().isPresent() && ((AppliesTo)testCase.getAppliesTo().get()).toString().equals("server")) {
                        return;
                    }
                    String documentation = testCase.getDocumentation().orElse("");
                    ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write("", new Object[0])).writeDocstring(documentation).openBlock("it '$L' do", new Object[]{testCase.getId()})).call(() -> this.renderResponseStubResponse(operation, (HttpResponseTestCase)testCase))).call(() -> this.renderSkipBuild(operation))).openBlock("begin", new Object[0])).write("client.$L({})", new Object[]{operationName})).dedent()).write("rescue Errors::$L => e", new Object[]{error.getId().getName()})).indent()).write("expect(e.data.to_h).to eq($L)", new Object[]{this.getRubyHashFromParams((Shape)error, testCase.getParams())})).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
                    LOGGER.finer("Generated protocol error response test for operation " + operationName + " test: " + testCase.getId());
                    ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write("", new Object[0])).writeDocstring(documentation).openBlock("it 'stubs $L' do", new Object[]{testCase.getId()})).write("client.stub_responses(:$L, error: { class: Errors::$L, data: $L })", new Object[]{operationName, error.getId().getName(), this.getRubyHashFromParams((Shape)error, testCase.getParams())})).call(() -> this.renderSkipBuild(operation))).openBlock("begin", new Object[0])).write("client.$L({})", new Object[]{operationName})).dedent()).write("rescue Errors::$L => e", new Object[]{error.getId().getName()})).indent()).write("expect(e.http_status).to eq($L)", new Object[]{testCase.getCode()})).write("expect(e.data.to_h).to eq($L)", new Object[]{this.getRubyHashFromParams((Shape)error, testCase.getParams())})).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
                    LOGGER.finer("Generated protocol error stub test for operation " + operationName + " test: " + testCase.getId());
                });
                this.writer.closeBlock("end", new Object[0]);
            });
        }
    }

    private String getRubyHashFromParams(Shape ioShape, ObjectNode params) {
        return (String)ioShape.accept((ShapeVisitor)new ParamsToHash(this.model, (Node)params, this.symbolProvider));
    }

    private String getRubyHashFromMap(Map<String, String> map) {
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        StringBuffer buffer = new StringBuffer("{ ");
        while (iterator.hasNext()) {
            Map.Entry<String, String> header = iterator.next();
            buffer.append("'");
            buffer.append((Object)header.getKey());
            buffer.append("' => '");
            buffer.append((Object)header.getValue());
            buffer.append("'");
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(" }");
        return buffer.toString();
    }

    private String getRubyArrayFromList(List<String> list) {
        Iterator<String> iterator = list.iterator();
        StringBuffer buffer = new StringBuffer("[");
        while (iterator.hasNext()) {
            String element = iterator.next();
            buffer.append("'");
            buffer.append(element);
            buffer.append("'");
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    private void renderSkipBuild(OperationShape operation) {
        String builderName = "Builders::" + this.context.symbolProvider().toSymbol((Shape)operation).getName();
        this.writer.write("allow($L).to receive(:build)", new Object[]{builderName});
    }

    private void renderResponseStubResponse(OperationShape operation, HttpResponseTestCase testCase) {
        String operationName = RubyFormatter.toSnakeCase(this.symbolProvider.toSymbol((Shape)operation).getName());
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write("response = Hearth::HTTP::Response.new", new Object[0])).write("response.status = $L", new Object[]{testCase.getCode()})).call(() -> this.renderResponseStubHeaders(testCase.getHeaders()))).call(() -> this.renderResponseStubBody(testCase.getBody()))).write("client.stub_responses(:$L, response)", new Object[]{operationName});
    }

    private void renderResponseStubBody(Optional<String> body) {
        if (body.isPresent()) {
            this.writer.write("response.body.write('$L')", new Object[]{body.get()});
            this.writer.write("response.body.rewind", new Object[0]);
        }
    }

    private void renderResponseStubHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> header : headers.entrySet()) {
            this.writer.write("response.headers['$L'] = '$L'", new Object[]{header.getKey(), header.getValue()});
        }
    }

    private void renderRequestInterceptor(HttpRequestTestCase testCase) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("proc = proc do |context|", new Object[0])).write("request = context.request", new Object[0])).write("expect(request.http_method).to eq('$L')", new Object[]{testCase.getMethod()})).call(() -> this.renderRequestInterceptorHost(testCase.getResolvedHost()))).write("expect(request.uri.path).to eq('$L')", new Object[]{testCase.getUri()})).call(() -> this.renderRequestInterceptorQueryParams(testCase.getQueryParams()))).call(() -> this.renderRequestInterceptorForbidQueryParams(testCase.getForbidQueryParams()))).call(() -> this.renderRequestInterceptorRequireQueryParams(testCase.getRequireQueryParams()))).call(() -> this.renderRequestInterceptorHeaders(testCase.getHeaders()))).call(() -> this.renderRequestInterceptorForbiddenHeaders(testCase.getForbidHeaders()))).call(() -> this.renderRequestInterceptorRequiredHeaders(testCase.getRequireHeaders()))).call(() -> this.renderRequestInterceptorBody(testCase.getBody(), testCase.getBodyMediaType()))).closeBlock("end", new Object[0]);
    }

    private void renderRequestInterceptorHost(Optional<String> resolvedHost) {
        if (resolvedHost.isPresent()) {
            this.writer.write("expect(request.uri.host).to eq('$L')", new Object[]{resolvedHost.get()});
        }
    }

    private void renderRequestInterceptorBody(Optional<String> body, Optional<String> bodyMediaType) {
        if (body.isPresent()) {
            if (bodyMediaType.isPresent()) {
                switch (bodyMediaType.get()) {
                    case "application/json": {
                        this.writer.write("expect(JSON.parse(request.body.read)).to eq(JSON.parse('$L'))", new Object[]{body.get()});
                        break;
                    }
                    case "application/xml": {
                        if (body.get().length() > 0) {
                            ((RubyCodeWriter)this.writer.write("expect($1T.parse(request.body.read)).to match_xml_node($1T.parse('$2L'))", new Object[]{Hearth.XML, body.get()})).addUseImports(RubyDependency.HEARTH_XML_MATCHER);
                            break;
                        }
                        this.writer.write("expect(request.body.read).to eq('$L')", new Object[]{body.get()});
                        break;
                    }
                    case "application/x-www-form-urlencoded": {
                        ((RubyCodeWriter)this.writer.write("expect($1T.parse(request.body.read)).to match_query_params($1T.parse('$2L'))", new Object[]{RubyImportContainer.CGI, body.get()})).addUseImports(RubyDependency.HEARTH_QUERY_PARAM_MATCHER);
                        break;
                    }
                    default: {
                        this.writer.write("expect(request.body.read).to eq('$L')", new Object[]{body.get()});
                        break;
                    }
                }
            } else {
                this.writer.write("expect(request.body.read).to eq('$L')", new Object[]{body.get()});
            }
        }
    }

    private void renderRequestInterceptorHeaders(Map<String, String> headers) {
        if (!headers.isEmpty()) {
            this.writer.write("$L.each { |k, v| expect(request.headers[k]).to eq(v) } ", new Object[]{this.getRubyHashFromMap(headers)});
        }
    }

    private void renderRequestInterceptorForbiddenHeaders(List<String> forbiddenHeaders) {
        if (!forbiddenHeaders.isEmpty()) {
            this.writer.write("$L.each { |k| expect(request.headers.key?(k)).to be(false) } ", new Object[]{this.getRubyArrayFromList(forbiddenHeaders)});
        }
    }

    private void renderRequestInterceptorRequiredHeaders(List<String> requiredHeaders) {
        if (!requiredHeaders.isEmpty()) {
            this.writer.write("$L.each { |k| expect(request.headers.key?(k)).to be(true) } ", new Object[]{this.getRubyArrayFromList(requiredHeaders)});
        }
    }

    private void renderRequestInterceptorQueryParams(List<String> queryParams) {
        if (!queryParams.isEmpty()) {
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write("expected_query = $T.parse($L.join('&'))", new Object[]{RubyImportContainer.CGI, this.getRubyArrayFromList(queryParams)})).write("actual_query = $T.parse(request.uri.query)", new Object[]{RubyImportContainer.CGI})).openBlock("expected_query.each do |k, v|", new Object[0])).write("expect(actual_query[k]).to eq(v)", new Object[0])).closeBlock("end", new Object[0]);
        }
    }

    private void renderRequestInterceptorForbidQueryParams(List<String> forbidQueryParams) {
        if (!forbidQueryParams.isEmpty()) {
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write("forbid_query = $L", new Object[]{this.getRubyArrayFromList(forbidQueryParams)})).write("actual_query = $T.parse(request.uri.query)", new Object[]{RubyImportContainer.CGI})).openBlock("forbid_query.each do |query|", new Object[0])).write("expect(actual_query.key?(query)).to be false", new Object[0])).closeBlock("end", new Object[0]);
        }
    }

    private void renderRequestInterceptorRequireQueryParams(List<String> requireQueryParams) {
        if (!requireQueryParams.isEmpty()) {
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write("require_query = $L", new Object[]{this.getRubyArrayFromList(requireQueryParams)})).write("actual_query = $T.parse(request.uri.query)", new Object[]{RubyImportContainer.CGI})).openBlock("require_query.each do |query|", new Object[0])).write("expect(actual_query.key?(query)).to be true", new Object[0])).closeBlock("end", new Object[0]);
        }
    }

    private void renderResponseStubInterceptor(HttpResponseTestCase testCase) {
        ((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("proc = proc do |context|", new Object[0])).write("expect(context.response.status).to eq($L)", new Object[]{testCase.getCode()})).closeBlock("end", new Object[0]);
    }

    private void renderStreamingParamReader(Shape outputShape) {
        MemberShape streamingMember = outputShape.members().stream().filter(m -> m.getMemberTrait(this.model, StreamingTrait.class).isPresent()).findFirst().get();
        String memberName = this.symbolProvider.toMemberName(streamingMember);
        ((RubyCodeWriter)((RubyCodeWriter)this.writer.write("output.data.$L.rewind", new Object[]{memberName})).write("output.data.$1L = output.data.$1L.read", new Object[]{memberName})).write("output.data.$1L = nil if output.data.$1L.empty?", new Object[]{memberName});
    }
}

