/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.codegen.core.directed.ContextualDirective;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.ServiceIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.auth.AuthScheme;
import software.amazon.smithy.ruby.codegen.generators.RubyGeneratorBase;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class AuthGenerator
extends RubyGeneratorBase {
    private static final Logger LOGGER = Logger.getLogger(AuthGenerator.class.getName());
    private final Set<OperationShape> operations;
    private final ServiceShape service;
    private final Set<AuthScheme> authSchemes;

    public AuthGenerator(ContextualDirective<GenerationContext, RubySettings> directive) {
        super(directive);
        this.operations = directive.operations();
        this.service = directive.service();
        this.authSchemes = ((GenerationContext)directive.context()).getAuthSchemes();
    }

    @Override
    String getModule() {
        return "Auth";
    }

    public void render() {
        List additionalFiles = this.authSchemes.stream().map(a -> a.writeAdditionalFiles(this.context)).flatMap(Collection::stream).distinct().sorted().collect(Collectors.toList());
        this.write(writer -> ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.preamble().includeRequires().writeRequireRelativeAdditionalFiles(additionalFiles).addModule(this.settings.getModule()).addModule("Auth").call(() -> this.renderAuthParamsClass((RubyCodeWriter)((Object)writer)))).write("", new Object[0])).call(() -> this.renderAuthSchemesConstant((RubyCodeWriter)((Object)writer)))).write("", new Object[0])).call(() -> this.renderAuthResolver((RubyCodeWriter)((Object)writer)))).closeAllModules());
        LOGGER.fine("Wrote auth module to " + this.rbFile());
    }

    public void renderRbs() {
        this.writeRbs(writer -> ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.preamble().addModule(this.settings.getModule()).addModule("Auth").call(() -> this.renderRbsAuthParamsClass((RubyCodeWriter)((Object)writer)))).write("", new Object[0])).call(() -> this.renderRbsAuthSchemesConstant((RubyCodeWriter)((Object)writer)))).write("", new Object[0])).call(() -> this.renderRbsAuthResolver((RubyCodeWriter)((Object)writer)))).closeAllModules());
        LOGGER.fine("Wrote auth rbs module to " + this.rbsFile());
    }

    private void renderAuthParamsClass(RubyCodeWriter writer) {
        ArrayList<String> authParamsList = new ArrayList<String>();
        authParamsList.add(":operation_name");
        this.authSchemes.forEach(s -> {
            Map<String, String> additionalAuthParams = s.getAdditionalAuthParams();
            additionalAuthParams.entrySet().stream().forEach(e -> authParamsList.add(RubyFormatter.asSymbol((String)e.getKey())));
        });
        String authParams = authParamsList.stream().collect(Collectors.joining(", "));
        writer.write("Params = Struct.new($L, keyword_init: true)", new Object[]{authParams});
    }

    private void renderRbsAuthParamsClass(RubyCodeWriter writer) {
        HashMap<String, String> authParamsMap = new HashMap<String, String>();
        authParamsMap.put("operation_name", "::Symbol");
        this.authSchemes.forEach(s -> {
            Map<String, String> additionalAuthParams = s.getAdditionalAuthParams();
            additionalAuthParams.entrySet().stream().forEach(e -> authParamsMap.put(RubyFormatter.toSnakeCase((String)e.getKey()), "untyped"));
        });
        ((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("class Params < ::Struct[untyped]", new Object[0])).call(() -> authParamsMap.entrySet().stream().forEach(e -> writer.write("attr_accessor $L (): $L", new Object[]{e.getKey(), e.getValue()})))).closeBlock("end", new Object[0]);
    }

    private void renderAuthSchemesConstant(RubyCodeWriter writer) {
        HashSet authTraits = new HashSet();
        this.operations.stream().forEach(operation -> ServiceIndex.of((Model)this.model).getEffectiveAuthSchemes((ToShapeId)this.service, (ToShapeId)operation, ServiceIndex.AuthSchemeMode.NO_AUTH_AWARE).forEach((shapeId, trait) -> authTraits.add(trait)));
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("SCHEMES = [", new Object[0])).call(() -> authTraits.stream().sorted(Comparator.comparing(Trait::toShapeId)).forEach(authTrait -> {
            ShapeId shapeId = authTrait.toShapeId();
            AuthScheme authScheme = this.authSchemes.stream().filter(s -> s.getShapeId().equals((Object)shapeId)).findFirst().orElseThrow(() -> new IllegalStateException("No auth scheme found for " + shapeId));
            writer.write("$L,", new Object[]{authScheme.getRubyAuthScheme()});
        }))).unwrite(",\n", new Object[0])).write("", new Object[0])).closeBlock("].freeze", new Object[0]);
    }

    private void renderRbsAuthSchemesConstant(RubyCodeWriter writer) {
        writer.write("SCHEMES: ::Array[Hearth::AuthSchemes::Base]", new Object[0]);
    }

    private void renderAuthResolver(RubyCodeWriter writer) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("class Resolver", new Object[0])).write("", new Object[0])).openBlock("def resolve(auth_params)", new Object[0])).write("options = []", new Object[0])).write("case auth_params.operation_name", new Object[0])).call(() -> {
            for (OperationShape operation : this.operations) {
                this.renderOperationAuthOptionsCase(writer, operation);
            }
        })).write("end", new Object[0])).closeBlock("end", new Object[0])).write("", new Object[0])).closeBlock("end", new Object[0]);
    }

    private void renderRbsAuthResolver(RubyCodeWriter writer) {
        ((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("class Resolver", new Object[0])).write("def resolve: (auth_params: Params) -> ::Array[Hearth::AuthOption]", new Object[0])).closeBlock("end", new Object[0]);
    }

    private void renderOperationAuthOptionsCase(RubyCodeWriter writer, OperationShape operation) {
        String operationName = RubyFormatter.asSymbol(this.symbolProvider.toSymbol((Shape)operation).getName());
        Map operationAuthSchemes = ServiceIndex.of((Model)this.model).getEffectiveAuthSchemes((ToShapeId)this.service, (ToShapeId)operation, ServiceIndex.AuthSchemeMode.NO_AUTH_AWARE);
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.write("when $L", new Object[]{operationName})).indent()).call(() -> operationAuthSchemes.forEach((shapeId, trait) -> {
            AuthScheme authScheme = this.authSchemes.stream().filter(s -> s.getShapeId().equals(shapeId)).findFirst().orElseThrow(() -> new IllegalStateException("No auth scheme found for " + shapeId));
            this.renderAuthOption(writer, shapeId.toString(), (Trait)trait, authScheme);
        }))).dedent();
    }

    private void renderAuthOption(RubyCodeWriter writer, String schemeId, Trait trait, AuthScheme authScheme) {
        Map<String, String> identityPropertiesMap;
        Object args = "scheme_id: '%s'".formatted(schemeId);
        Map<String, String> signerPropertiesMap = authScheme.getSignerProperties(trait);
        if (!signerPropertiesMap.isEmpty()) {
            String signerProperties = signerPropertiesMap.entrySet().stream().map(e -> "%s: %s".formatted(e.getKey(), e.getValue())).reduce((a, b) -> a + ", " + b).map(s -> " " + s + " ").orElse("");
            args = (String)args + ", signer_properties: {%s}".formatted(signerProperties);
        }
        if (!(identityPropertiesMap = authScheme.getIdentityProperties(trait)).isEmpty()) {
            String identityProperties = identityPropertiesMap.entrySet().stream().map(e -> "%s: %s".formatted(e.getKey(), e.getValue())).reduce((a, b) -> a + ", " + b).map(s -> " " + s + " ").orElse("");
            args = (String)args + ", identity_properties: {%s}".formatted(identityProperties);
        }
        writer.write("options << $L.new($L)", new Object[]{Hearth.AUTH_OPTION, args});
    }
}

