/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.config.ConfigConstraint;
import software.amazon.smithy.ruby.codegen.config.ConfigDefaults;
import software.amazon.smithy.ruby.codegen.config.ConfigProviderChain;
import software.amazon.smithy.ruby.codegen.config.DefaultLiteral;
import software.amazon.smithy.ruby.codegen.config.TypeConstraint;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public class ClientConfig {
    private final String name;
    private final String documentation;
    private final String documentationType;
    private final String rbsType;
    private final ConfigDefaults defaults;
    private final List<ConfigConstraint> constraints;

    public ClientConfig(Builder builder) {
        this.name = builder.name;
        this.documentation = builder.documentation;
        this.documentationType = builder.documentationType != null ? builder.documentationType : builder.type;
        this.rbsType = builder.rbsType != null ? builder.rbsType : builder.type;
        this.defaults = builder.defaults != null ? builder.defaults : new DefaultLiteral("[]");
        if (builder.documentationDefaultValue != null) {
            this.defaults.setDocumentationDefault(builder.documentationDefaultValue);
        }
        this.constraints = List.copyOf(builder.constraints);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public String renderGetConfigValue() {
        return "config." + this.getName();
    }

    public String getDocumentation() {
        if (this.documentation != null) {
            return this.documentation;
        }
        return "";
    }

    public String getDocumentationDefaultValue() {
        return this.defaults.getDocumentationDefault().orElse("");
    }

    public String getDocumentationType() {
        return this.documentationType;
    }

    public String getRbsType() {
        return this.rbsType;
    }

    public String renderDefaults(GenerationContext context) {
        return this.defaults.renderDefault(context);
    }

    public List<ConfigConstraint> getConstraints() {
        return this.constraints;
    }

    public void addToConfigCollection(Set<ClientConfig> configCollection) {
        if (!configCollection.contains(this)) {
            configCollection.add(this);
            this.defaults.addToConfigCollection(configCollection);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientConfig that = (ClientConfig)o;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getDocumentationType(), that.getDocumentationType());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getDocumentationType());
    }

    public static class Builder
    implements SmithyBuilder<ClientConfig> {
        private String name;
        private String type;
        private String documentation;
        private String documentationDefaultValue;
        private String documentationType;
        private String rbsType;
        private ConfigDefaults defaults;
        private final List<ConfigConstraint> constraints = new ArrayList<ConfigConstraint>();

        protected Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.constraints.add(0, new TypeConstraint(type));
            return this;
        }

        public Builder documentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        public Builder documentationDefaultValue(String defaultValue) {
            this.documentationDefaultValue = defaultValue;
            return this;
        }

        public Builder documentationType(String type) {
            this.documentationType = type;
            return this;
        }

        public Builder rbsType(String type) {
            this.rbsType = type;
            return this;
        }

        public Builder defaultPrimitiveValue(String value) {
            this.validateDefaultNotSet();
            this.defaults = ConfigProviderChain.builder().staticProvider(value).build();
            return this;
        }

        public Builder defaultDynamicValue(String rubyProcBody) {
            this.validateDefaultNotSet();
            this.defaults = ConfigProviderChain.builder().dynamicProvider(rubyProcBody).build();
            return this;
        }

        public Builder defaultValue(String value) {
            this.validateDefaultNotSet();
            this.defaults = ConfigProviderChain.builder().staticProvider(value).build();
            return this;
        }

        public Builder constraint(ConfigConstraint constraint) {
            this.constraints.add(constraint);
            return this;
        }

        public ClientConfig build() {
            return new ClientConfig(this);
        }

        private void validateDefaultNotSet() {
            if (this.defaults != null) {
                throw new IllegalArgumentException("ConfigDefaults have already been set.");
            }
        }
    }
}

