/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.codegen.core.CodegenContext;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.codegen.core.SymbolWriter;
import software.amazon.smithy.codegen.core.WriterDelegator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.ruby.codegen.ApplicationTransport;
import software.amazon.smithy.ruby.codegen.ProtocolGenerator;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyDependency;
import software.amazon.smithy.ruby.codegen.RubyIntegration;
import software.amazon.smithy.ruby.codegen.RubyRuntimePlugin;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.auth.AuthScheme;
import software.amazon.smithy.ruby.codegen.auth.factories.AnonymousAuthSchemeFactory;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public class GenerationContext
implements CodegenContext<RubySettings, RubyCodeWriter, RubyIntegration> {
    private final RubySettings rubySettings;
    private final FileManifest fileManifest;
    private final List<RubyIntegration> integrations;
    private final Model model;
    private final ServiceShape service;
    private final ShapeId protocol;
    private final Optional<ProtocolGenerator> protocolGenerator;
    private final ApplicationTransport applicationTransport;
    private final SymbolProvider symbolProvider;
    private final WriterDelegator<RubyCodeWriter> writerDelegator;

    public GenerationContext(RubySettings rubySettings, FileManifest fileManifest, List<RubyIntegration> integrations, Model model, ServiceShape service, ShapeId protocol, Optional<ProtocolGenerator> protocolGenerator, ApplicationTransport applicationTransport, SymbolProvider symbolProvider) {
        this.rubySettings = rubySettings;
        this.fileManifest = fileManifest;
        this.integrations = integrations;
        this.model = model;
        this.service = service;
        this.protocol = protocol;
        this.protocolGenerator = protocolGenerator;
        this.applicationTransport = applicationTransport;
        this.symbolProvider = symbolProvider;
        this.writerDelegator = new WriterDelegator(fileManifest, symbolProvider, (SymbolWriter.Factory)new RubyCodeWriter.Factory());
    }

    public Model model() {
        return this.model;
    }

    public RubySettings settings() {
        return this.rubySettings;
    }

    public SymbolProvider symbolProvider() {
        return this.symbolProvider;
    }

    public FileManifest fileManifest() {
        return this.fileManifest;
    }

    public WriterDelegator<RubyCodeWriter> writerDelegator() {
        return this.writerDelegator;
    }

    public List<RubyIntegration> integrations() {
        return this.integrations;
    }

    public ServiceShape service() {
        return this.service;
    }

    public ApplicationTransport applicationTransport() {
        return this.applicationTransport;
    }

    public ShapeId protocol() {
        return this.protocol;
    }

    public Optional<ProtocolGenerator> protocolGenerator() {
        return this.protocolGenerator;
    }

    public Set<RubyDependency> getRubyDependencies() {
        HashSet<RubyDependency> rubyDependencies = new HashSet<RubyDependency>();
        rubyDependencies.addAll(this.settings().getBaseDependencies());
        rubyDependencies.addAll(this.integrations.stream().map(integration -> integration.getAdditionalGemDependencies(this)).flatMap(Collection::stream).collect(Collectors.toSet()));
        return Collections.unmodifiableSet(rubyDependencies);
    }

    public Set<RubyRuntimePlugin> getRuntimePlugins() {
        return this.integrations.stream().map(i -> i.getRuntimePlugins(this)).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
    }

    public Set<AuthScheme> getAuthSchemes() {
        HashSet<AuthScheme> authSchemes = new HashSet<AuthScheme>(this.applicationTransport.defaultAuthSchemes());
        authSchemes.add(AnonymousAuthSchemeFactory.build());
        this.integrations().forEach(i -> i.getAdditionalAuthSchemes(this).forEach(s -> authSchemes.add((AuthScheme)s)));
        return Collections.unmodifiableSet(authSchemes);
    }
}

