/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.shapes.BigDecimalShape;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.RubySymbolProvider;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class ValidatorsGenerator
extends ShapeVisitor.Default<Void> {
    private static final Logger LOGGER = Logger.getLogger(ValidatorsGenerator.class.getName());
    private final GenerationContext context;
    private final RubySettings settings;
    private final Model model;
    private final RubyCodeWriter writer;
    private final SymbolProvider symbolProvider;

    public ValidatorsGenerator(GenerationContext context) {
        this.context = context;
        this.settings = context.getRubySettings();
        this.model = context.getModel();
        this.writer = new RubyCodeWriter();
        this.symbolProvider = new RubySymbolProvider(this.model, this.settings, "Validators", true);
    }

    public void render() {
        FileManifest fileManifest = this.context.getFileManifest();
        this.writer.writePreamble().openBlock("module $L", new Object[]{this.settings.getModule()}).openBlock("module Validators", new Object[0]).call(() -> this.renderValidators()).write((Object)"", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        String fileName = this.settings.getGemName() + "/lib/" + this.settings.getGemName() + "/validators.rb";
        fileManifest.writeFile(fileName, this.writer.toString());
        LOGGER.fine("Wrote validators to " + fileName);
    }

    private void renderValidators() {
        TopDownIndex topDownIndex = TopDownIndex.of((Model)this.model);
        OperationIndex operationIndex = OperationIndex.of((Model)this.model);
        Walker walker = new Walker(this.model);
        Set inputShapes = topDownIndex.getContainedOperations((ToShapeId)this.context.getService()).stream().flatMap(operation -> OptionalUtils.stream((Optional)operationIndex.getInputShape((ToShapeId)operation))).flatMap(input -> walker.walkShapes((Shape)input).stream()).collect(Collectors.toSet());
        inputShapes.stream().sorted(Comparator.comparing(o -> o.getId().getName())).forEach(inputShape -> {
            Void cfr_ignored_0 = (Void)inputShape.accept((ShapeVisitor)this);
        });
    }

    public Void structureShape(StructureShape structureShape) {
        Collection members = structureShape.members();
        String name = this.symbolProvider.toSymbol((Shape)structureShape).getName();
        this.writer.write("", new Object[0]).openBlock("class $L", new Object[]{name}).openBlock("def self.validate!(input, context:)", new Object[0]).write((Object)"Seahorse::Validator.validate!(input, Types::$L, context: context)", new Object[]{name}).call(() -> this.renderValidatorsForStructureMembers(members)).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        return null;
    }

    private void renderValidatorsForStructureMembers(Collection<MemberShape> members) {
        members.forEach(member -> {
            Shape target = this.model.expectShape(member.getTarget());
            String symbolName = ":" + this.symbolProvider.toMemberName(member);
            String input = "input[" + symbolName + "]";
            String context = "\"#{context}[" + symbolName + "]\"";
            target.accept((ShapeVisitor)new MemberValidator(this.writer, this.symbolProvider, input, context));
        });
    }

    public Void mapShape(MapShape mapShape) {
        Shape valueTarget = this.model.expectShape(mapShape.getValue().getTarget());
        this.writer.write("", new Object[0]).openBlock("class $L", new Object[]{this.symbolProvider.toSymbol((Shape)mapShape).getName()}).openBlock("def self.validate!(input, context:)", new Object[0]).write((Object)"Seahorse::Validator.validate!(input, ::Hash, context: context)", new Object[0]).openBlock("input.each do |key, value|", new Object[0]).write((Object)"Seahorse::Validator.validate!(key, ::String, ::Symbol, context: \"#{context}.keys\")", new Object[0]).call(() -> {
            Void cfr_ignored_0 = (Void)valueTarget.accept((ShapeVisitor)new MemberValidator(this.writer, this.symbolProvider, "value", "\"#{context}[:#{key}]\""));
        }).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        return null;
    }

    public Void listShape(ListShape listShape) {
        Shape memberTarget = this.model.expectShape(listShape.getMember().getTarget());
        this.writer.write("", new Object[0]).openBlock("class $L", new Object[]{this.symbolProvider.toSymbol((Shape)listShape).getName()}).openBlock("def self.validate!(input, context:)", new Object[0]).write((Object)"Seahorse::Validator.validate!(input, ::Array, context: context)", new Object[0]).openBlock("input.each_with_index do |element, index|", new Object[0]).call(() -> {
            Void cfr_ignored_0 = (Void)memberTarget.accept((ShapeVisitor)new MemberValidator(this.writer, this.symbolProvider, "element", "\"#{context}[#{index}]\""));
        }).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        return null;
    }

    public Void setShape(SetShape setShape) {
        Shape memberTarget = this.model.expectShape(setShape.getMember().getTarget());
        this.writer.write("", new Object[0]).openBlock("class $L", new Object[]{this.symbolProvider.toSymbol((Shape)setShape).getName()}).openBlock("def self.validate!(input, context:)", new Object[0]).write((Object)"Seahorse::Validator.validate!(input, ::Set, context: context)", new Object[0]).openBlock("input.each_with_index do |element, index|", new Object[0]).call(() -> {
            Void cfr_ignored_0 = (Void)memberTarget.accept((ShapeVisitor)new MemberValidator(this.writer, this.symbolProvider, "element", "\"#{context}[#{index}]\""));
        }).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        return null;
    }

    public Void unionShape(UnionShape unionShape) {
        String shapeName = this.symbolProvider.toSymbol((Shape)unionShape).getName();
        Collection unionMemberShapes = unionShape.members();
        this.writer.write("", new Object[0]).openBlock("class $L", new Object[]{shapeName}).openBlock("def self.validate!(input, context:)", new Object[0]).write((Object)"case input", new Object[0]).call(() -> unionMemberShapes.forEach(unionMemberShape -> {
            String unionMemberName = this.symbolProvider.toMemberName(unionMemberShape);
            this.writer.write("when Types::" + shapeName + "::" + unionMemberName, new Object[0]).indent();
            this.model.expectShape(unionMemberShape.getTarget()).accept((ShapeVisitor)new MemberValidator(this.writer, this.symbolProvider, "input.__getobj__", "context"));
            this.writer.dedent();
        })).write((Object)"else", new Object[0]).write((Object)"  raise ArgumentError,", new Object[0]).write((Object)"        \"Expected #{context} to be a union member of \"\\", new Object[0]).write((Object)("        \"Types::" + shapeName + ", got #{input.class}.\""), new Object[0]).write((Object)"end", new Object[0]).closeBlock("end", new Object[0]).call(() -> this.renderValidatorsForUnionMembers(unionMemberShapes)).closeBlock("end", new Object[0]);
        return null;
    }

    public Void documentShape(DocumentShape documentShape) {
        this.writer.write("", new Object[0]).openBlock("class $L", new Object[]{this.symbolProvider.toSymbol((Shape)documentShape).getName()}).openBlock("def self.validate!(input, context:)", new Object[0]).write((Object)"Seahorse::Validator.validate!(input, ::Hash, ::String, ::Array, ::TrueClass, ::FalseClass, ::Numeric, context: context)", new Object[0]).write((Object)"case input", new Object[0]).openBlock("when ::Hash", new Object[0]).write((Object)"input.each do |k,v|", new Object[0]).indent().write((Object)"validate!(v, context: \"#{context}[:#{k}]\")", new Object[0]).closeBlock("end", new Object[0]).dedent().write((Object)"when ::Array", new Object[0]).indent().openBlock("input.each_with_index do |v, i|", new Object[0]).write((Object)"validate!(v, context: \"#{context}[#{i}]\")", new Object[0]).closeBlock("end", new Object[0]).dedent().write((Object)"end", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        return null;
    }

    private void renderValidatorsForUnionMembers(Collection<MemberShape> members) {
        members.forEach(member -> {
            String name = this.symbolProvider.toMemberName(member);
            Shape target = this.model.expectShape(member.getTarget());
            this.writer.write("", new Object[0]).openBlock("class $L", new Object[]{name}).openBlock("def self.validate!(input, context:)", new Object[0]).call(() -> {
                Void cfr_ignored_0 = (Void)target.accept((ShapeVisitor)new MemberValidator(this.writer, this.symbolProvider, "input", "context"));
            }).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        });
    }

    protected Void getDefault(Shape shape) {
        return null;
    }

    private static class MemberValidator
    extends ShapeVisitor.Default<Void> {
        private final RubyCodeWriter writer;
        private final SymbolProvider symbolProvider;
        private final String input;
        private final String context;

        MemberValidator(RubyCodeWriter writer, SymbolProvider symbolProvider, String input, String context) {
            this.writer = writer;
            this.symbolProvider = symbolProvider;
            this.input = input;
            this.context = context;
        }

        protected Void getDefault(Shape shape) {
            return null;
        }

        public Void blobShape(BlobShape shape) {
            this.writer.write("Seahorse::Validator.validate!($L, ::String, context: $L)", new Object[]{this.input, this.context});
            return null;
        }

        public Void booleanShape(BooleanShape shape) {
            this.writer.write("Seahorse::Validator.validate!($L, ::TrueClass, ::FalseClass, context: $L)", new Object[]{this.input, this.context});
            return null;
        }

        public Void listShape(ListShape shape) {
            String name = this.symbolProvider.toSymbol((Shape)shape).getName();
            this.writer.write("Validators::$1L.validate!($2L, context: $3L) unless $2L.nil?", new Object[]{name, this.input, this.context});
            return null;
        }

        public Void setShape(SetShape shape) {
            String name = this.symbolProvider.toSymbol((Shape)shape).getName();
            this.writer.write("Validators::$1L.validate!($2L, context: $3L) unless $2L.nil?", new Object[]{name, this.input, this.context});
            return null;
        }

        public Void byteShape(ByteShape shape) {
            this.writer.write("Seahorse::Validator.validate!($L, ::Integer, context: $L)", new Object[]{this.input, this.context});
            return null;
        }

        public Void shortShape(ShortShape shape) {
            this.writer.write("Seahorse::Validator.validate!($L, ::Integer, context: $L)", new Object[]{this.input, this.context});
            return null;
        }

        public Void integerShape(IntegerShape shape) {
            this.writer.write("Seahorse::Validator.validate!($L, ::Integer, context: $L)", new Object[]{this.input, this.context});
            return null;
        }

        public Void longShape(LongShape shape) {
            this.writer.write("Seahorse::Validator.validate!($L, ::Integer, context: $L)", new Object[]{this.input, this.context});
            return null;
        }

        public Void floatShape(FloatShape shape) {
            this.writer.write("Seahorse::Validator.validate!($L, ::Float, context: $L)", new Object[]{this.input, this.context});
            return null;
        }

        public Void documentShape(DocumentShape shape) {
            String name = this.symbolProvider.toSymbol((Shape)shape).getName();
            this.writer.write("Validators::$1L.validate!($2L, context: $3L) unless $2L.nil?", new Object[]{name, this.input, this.context});
            return null;
        }

        public Void doubleShape(DoubleShape shape) {
            this.writer.write("Seahorse::Validator.validate!($L, ::Float, context: $L)", new Object[]{this.input, this.context});
            return null;
        }

        public Void bigDecimalShape(BigDecimalShape shape) {
            this.writer.write("Seahorse::Validator.validate!($L, ::BigDecimal, context: $L)", new Object[]{this.input, this.context});
            return null;
        }

        public Void mapShape(MapShape shape) {
            String name = this.symbolProvider.toSymbol((Shape)shape).getName();
            this.writer.write("Validators::$1L.validate!($2L, context: $3L) unless $2L.nil?", new Object[]{name, this.input, this.context});
            return null;
        }

        public Void stringShape(StringShape shape) {
            this.writer.write("Seahorse::Validator.validate!($L, ::String, context: $L)", new Object[]{this.input, this.context});
            return null;
        }

        public Void structureShape(StructureShape shape) {
            String name = this.symbolProvider.toSymbol((Shape)shape).getName();
            this.writer.write("Validators::$1L.validate!($2L, context: $3L) unless $2L.nil?", new Object[]{name, this.input, this.context});
            return null;
        }

        public Void unionShape(UnionShape shape) {
            String name = this.symbolProvider.toSymbol((Shape)shape).getName();
            this.writer.write("Validators::$1L.validate!($2L, context: $3L) unless $2L.nil?", new Object[]{name, this.input, this.context});
            return null;
        }

        public Void timestampShape(TimestampShape shape) {
            this.writer.write("Seahorse::Validator.validate!($L, ::Time, context: $L)", new Object[]{this.input, this.context});
            return null;
        }
    }
}

