/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.List;
import java.util.logging.Logger;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class ModuleGenerator {
    private static final Logger LOGGER = Logger.getLogger(ModuleGenerator.class.getName());
    private final GenerationContext context;

    public ModuleGenerator(GenerationContext context) {
        this.context = context;
    }

    public void render(List<String> additionalFiles) {
        FileManifest fileManifest = this.context.getFileManifest();
        RubySettings settings = this.context.getRubySettings();
        RubyCodeWriter writer = new RubyCodeWriter();
        writer.writePreamble();
        writer.write("require 'seahorse'\n", new Object[0]);
        String[] requires = new String[]{"builders", "client", "errors", "parsers", "types", "params", "validators", "stubs", "waiters", "paginators"};
        for (String require : requires) {
            writer.write("require_relative '$L/$L'", new Object[]{settings.getGemName(), require});
        }
        for (String require : additionalFiles) {
            writer.write("require_relative '$L'", new Object[]{require});
            LOGGER.finer("Adding additional module require: " + require);
        }
        writer.write("", new Object[0]);
        writer.openBlock("module $L", new Object[]{settings.getModule()}).write((Object)"GEM_VERSION = '$L'", new Object[]{settings.getGemVersion()}).closeBlock("end", new Object[0]);
        String fileName = settings.getGemName() + "/lib/" + settings.getGemName() + ".rb";
        fileManifest.writeFile(fileName, writer.toString());
        LOGGER.fine("Wrote module file to " + fileName);
    }
}

