/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.protocoltests.traits.AppliesTo;
import software.amazon.smithy.protocoltests.traits.HttpRequestTestCase;
import software.amazon.smithy.protocoltests.traits.HttpRequestTestsTrait;
import software.amazon.smithy.protocoltests.traits.HttpResponseTestCase;
import software.amazon.smithy.protocoltests.traits.HttpResponseTestsTrait;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.RubySymbolProvider;
import software.amazon.smithy.ruby.codegen.util.ParamsToHash;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class HttpProtocolTestGenerator {
    private static final Logger LOGGER = Logger.getLogger(HttpProtocolTestGenerator.class.getName());
    private final GenerationContext context;
    private final RubySettings settings;
    private final Model model;
    private final RubyCodeWriter writer;
    private final SymbolProvider symbolProvider;

    public HttpProtocolTestGenerator(GenerationContext context) {
        this.context = context;
        this.settings = context.getRubySettings();
        this.model = context.getModel();
        this.writer = new RubyCodeWriter();
        this.symbolProvider = new RubySymbolProvider(this.model, this.settings, "Protocol", true);
    }

    public void render() {
        FileManifest fileManifest = this.context.getFileManifest();
        this.writer.writePreamble().write("require '$L'\n", new Object[]{this.settings.getGemName()}).openBlock("module $L", new Object[]{this.settings.getModule()}).openBlock("describe Client do", new Object[0]).write((Object)"let(:endpoint) { 'http://127.0.0.1' } ", new Object[0]).write((Object)"let(:client) { Client.new(stub_responses: true, endpoint: endpoint) }", new Object[0]).write((Object)"", new Object[0]).call(() -> this.renderTests()).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        String fileName = this.settings.getGemName() + "/spec/protocol_spec.rb";
        fileManifest.writeFile(fileName, this.writer.toString());
        LOGGER.fine("Wrote protocol tests to " + fileName);
    }

    private void renderTests() {
        TopDownIndex topDownIndex = TopDownIndex.of((Model)this.model);
        topDownIndex.getContainedOperations((ToShapeId)this.context.getService()).stream().forEach(operation -> {
            String operationName = RubyFormatter.toSnakeCase(this.symbolProvider.toSymbol((Shape)operation).getName());
            this.writer.openBlock("describe '#$L' do", new Object[]{operationName});
            operation.getTrait(HttpRequestTestsTrait.class).ifPresent(requestTests -> this.renderRequestTests(operationName, operation.getInputShape(), (HttpRequestTestsTrait)requestTests));
            this.writer.write("", new Object[0]);
            operation.getTrait(HttpResponseTestsTrait.class).ifPresent(responseTests -> {
                this.renderResponseTests(operationName, operation.getOutputShape(), (HttpResponseTestsTrait)responseTests);
                this.renderResponseStubberTests(operationName, operation.getOutputShape(), (HttpResponseTestsTrait)responseTests);
            });
            this.renderErrorTests((OperationShape)operation);
            this.writer.closeBlock("end", new Object[0]);
        });
    }

    private void renderResponseTests(String operationName, ShapeId output, HttpResponseTestsTrait responseTests) {
        Shape outputShape = this.model.expectShape(output);
        this.writer.openBlock("describe 'responses' do", new Object[0]);
        responseTests.getTestCases().forEach(testCase -> {
            String documentation = testCase.getDocumentation().orElse("");
            this.writer.writeDocstring(documentation).openBlock("it '$L' do", new Object[]{testCase.getId()}).call(() -> this.renderResponseMiddleware((HttpResponseTestCase)testCase)).write((Object)"middleware.remove_send.remove_build", new Object[0]).write((Object)"output = client.$L({}, middleware: middleware)", new Object[]{operationName}).write((Object)"expect(output.to_h).to eq($L)", new Object[]{this.getRubyHashFromParams(outputShape, testCase.getParams())}).closeBlock("end", new Object[0]);
            LOGGER.finer("Generated protocol response test for operation " + operationName + " test: " + testCase.getId());
        });
        this.writer.closeBlock("end", new Object[0]);
    }

    private void renderResponseStubberTests(String operationName, ShapeId output, HttpResponseTestsTrait responseTests) {
        Shape outputShape = this.model.expectShape(output);
        this.writer.openBlock("describe 'response stubs' do", new Object[0]);
        responseTests.getTestCases().forEach(testCase -> {
            String documentation = testCase.getDocumentation().orElse("");
            this.writer.writeDocstring(documentation).openBlock("it 'stubs $L' do", new Object[]{testCase.getId()}).call(() -> this.renderResponseStubMiddleware((HttpResponseTestCase)testCase)).write((Object)"middleware.remove_build", new Object[0]).write((Object)"client.stub_responses(:$L, $L)", new Object[]{operationName, this.getRubyHashFromParams(outputShape, testCase.getParams())}).write((Object)"output = client.$L({}, middleware: middleware)", new Object[]{operationName}).write((Object)"expect(output.to_h).to eq($L)", new Object[]{this.getRubyHashFromParams(outputShape, testCase.getParams())}).closeBlock("end", new Object[0]);
            LOGGER.finer("Generated protocol response stubber test for operation " + operationName + " test: " + testCase.getId());
        });
        this.writer.closeBlock("end", new Object[0]);
    }

    private void renderRequestTests(String operationName, ShapeId input, HttpRequestTestsTrait requestTests) {
        Shape inputShape = this.model.expectShape(input);
        this.writer.openBlock("describe 'requests' do", new Object[0]);
        requestTests.getTestCases().forEach(testCase -> {
            if (testCase.getAppliesTo().isPresent() && ((AppliesTo)testCase.getAppliesTo().get()).toString().equals("server")) {
                return;
            }
            String documentation = testCase.getDocumentation().orElse("");
            this.writer.writeDocstring(documentation).openBlock("it '$L' do", new Object[]{testCase.getId()}).call(() -> this.renderRequestMiddleware((HttpRequestTestCase)testCase)).write((Object)"client.$L($L, middleware: middleware)", new Object[]{operationName, this.getRubyHashFromParams(inputShape, testCase.getParams())}).closeBlock("end", new Object[0]);
            LOGGER.finer("Generated protocol request test for operation " + operationName + " test: " + testCase.getId());
        });
        this.writer.closeBlock("end", new Object[0]);
    }

    private void renderErrorTests(OperationShape operation) {
        String operationName = RubyFormatter.toSnakeCase(operation.getId().getName());
        for (StructureShape error : OperationIndex.of((Model)this.model).getErrors((ToShapeId)operation)) {
            error.getTrait(HttpResponseTestsTrait.class).ifPresent(responseTests -> {
                this.writer.openBlock("describe '$L Errors' do", new Object[]{error.getId().getName()});
                responseTests.getTestCases().forEach(testCase -> {
                    String documentation = testCase.getDocumentation().orElse("");
                    this.writer.writeDocstring(documentation).openBlock("it '$L' do", new Object[]{testCase.getId()}).call(() -> this.renderResponseMiddleware((HttpResponseTestCase)testCase)).write((Object)"middleware.remove_send.remove_build", new Object[0]).openBlock("begin", new Object[0]).write((Object)"client.$L({}, middleware: middleware)", new Object[]{operationName}).dedent().write((Object)"rescue Errors::$L => e", new Object[]{error.getId().getName()}).indent().write((Object)"expect(e.data.to_h).to eq($L)", new Object[]{this.getRubyHashFromParams((Shape)error, testCase.getParams())}).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
                    LOGGER.finer("Generated protocol error test for operation " + operationName + " test: " + testCase.getId());
                });
                this.writer.closeBlock("end", new Object[0]);
            });
        }
    }

    private String getRubyHashFromParams(Shape ioShape, ObjectNode params) {
        return (String)ioShape.accept((ShapeVisitor)new ParamsToHash(this.model, (Node)params, this.symbolProvider));
    }

    private String getRubyHashFromMap(Map<String, String> map) {
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        StringBuffer buffer = new StringBuffer("{ ");
        while (iterator.hasNext()) {
            Map.Entry<String, String> header = iterator.next();
            buffer.append("'");
            buffer.append((Object)header.getKey());
            buffer.append("' => '");
            buffer.append((Object)header.getValue());
            buffer.append("'");
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(" }");
        return buffer.toString();
    }

    private String getRubyArrayFromList(List<String> list) {
        Iterator<String> iterator = list.iterator();
        StringBuffer buffer = new StringBuffer("[");
        while (iterator.hasNext()) {
            String element = iterator.next();
            buffer.append("'");
            buffer.append(element);
            buffer.append("'");
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    private void renderResponseMiddleware(HttpResponseTestCase testCase) {
        this.writer.openBlock("middleware = Seahorse::MiddlewareBuilder.around_send do |app, input, context|", new Object[0]).write((Object)"response = context.response", new Object[0]).write((Object)"response.status = $L", new Object[]{testCase.getCode()}).call(() -> this.renderResponseMiddlewareHeaders(testCase.getHeaders())).call(() -> this.renderResponseMiddlewareBody(testCase.getBody())).write((Object)"Seahorse::Output.new", new Object[0]).closeBlock("end", new Object[0]);
    }

    private void renderResponseMiddlewareBody(Optional<String> body) {
        if (body.isPresent()) {
            this.writer.write("response.body = StringIO.new('$L')", new Object[]{body.get()});
        }
    }

    private void renderResponseMiddlewareHeaders(Map<String, String> headers) {
        if (!headers.isEmpty()) {
            this.writer.write("response.headers = Seahorse::HTTP::Headers.new(headers: $L)", new Object[]{this.getRubyHashFromMap(headers)});
        }
    }

    private void renderRequestMiddleware(HttpRequestTestCase testCase) {
        this.writer.openBlock("middleware = Seahorse::MiddlewareBuilder.before_send do |input, context|", new Object[0]).write((Object)"request = context.request", new Object[0]).write((Object)"request_uri = URI.parse(request.url)", new Object[0]).write((Object)"expect(request.http_method).to eq('$L')", new Object[]{testCase.getMethod()}).write((Object)"expect(request_uri.path).to eq('$L')", new Object[]{testCase.getUri()}).call(() -> this.renderRequestMiddlewareQueryParams(testCase.getQueryParams())).call(() -> this.renderRequestMiddlewareForbidQueryParams(testCase.getForbidQueryParams())).call(() -> this.renderRequestMiddlewareRequireQueryParams(testCase.getRequireQueryParams())).call(() -> this.renderRequestMiddlewareHeaders(testCase.getHeaders())).call(() -> this.renderRequestMiddlewareForbiddenHeaders(testCase.getForbidHeaders())).call(() -> this.renderRequestMiddlewareRequiredHeaders(testCase.getRequireHeaders())).call(() -> this.renderRequestMiddlewareBody(testCase.getBody(), testCase.getBodyMediaType())).write((Object)"Seahorse::Output.new", new Object[0]).closeBlock("end", new Object[0]);
    }

    private void renderRequestMiddlewareBody(Optional<String> body, Optional<String> bodyMediaType) {
        if (body.isPresent()) {
            if (bodyMediaType.isPresent()) {
                switch (bodyMediaType.get()) {
                    case "application/json": {
                        this.writer.write("expect(JSON.parse(request.body.read)).to eq(JSON.parse('$L'))", new Object[]{body.get()});
                        break;
                    }
                    default: {
                        this.writer.write("expect(request.body.read).to eq('$L')", new Object[]{body.get()});
                        break;
                    }
                }
            } else {
                this.writer.write("expect(request.body.read).to eq('$L')", new Object[]{body.get()});
            }
        }
    }

    private void renderRequestMiddlewareHeaders(Map<String, String> headers) {
        if (!headers.isEmpty()) {
            this.writer.write("$L.each { |k, v| expect(request.headers[k]).to eq(v) } ", new Object[]{this.getRubyHashFromMap(headers)});
        }
    }

    private void renderRequestMiddlewareForbiddenHeaders(List<String> forbiddenHeaders) {
        if (!forbiddenHeaders.isEmpty()) {
            this.writer.write("$L.each { |k| expect(request.headers.key?(k)).to be(false) } ", new Object[]{this.getRubyArrayFromList(forbiddenHeaders)});
        }
    }

    private void renderRequestMiddlewareRequiredHeaders(List<String> requiredHeaders) {
        if (!requiredHeaders.isEmpty()) {
            this.writer.write("$L.each { |k| expect(request.headers.key?(k)).to be(true) } ", new Object[]{this.getRubyArrayFromList(requiredHeaders)});
        }
    }

    private void renderRequestMiddlewareQueryParams(List<String> queryParams) {
        if (!queryParams.isEmpty()) {
            this.writer.write("expected_query = CGI.parse($L.join('&'))", new Object[]{this.getRubyArrayFromList(queryParams)}).write((Object)"actual_query = CGI.parse(request_uri.query)", new Object[0]).openBlock("expected_query.each do |k, v|", new Object[0]).write((Object)"expect(actual_query[k]).to eq(v)", new Object[0]).closeBlock("end", new Object[0]);
        }
    }

    private void renderRequestMiddlewareForbidQueryParams(List<String> forbidQueryParams) {
        if (!forbidQueryParams.isEmpty()) {
            this.writer.write("forbid_query = $L", new Object[]{this.getRubyArrayFromList(forbidQueryParams)}).write((Object)"actual_query = CGI.parse(request_uri.query)", new Object[0]).openBlock("forbid_query.each do |query|", new Object[0]).write((Object)"expect(actual_query.key?(query)).to be false", new Object[0]).closeBlock("end", new Object[0]);
        }
    }

    private void renderRequestMiddlewareRequireQueryParams(List<String> requireQueryParams) {
        if (!requireQueryParams.isEmpty()) {
            this.writer.write("require_query = $L", new Object[]{this.getRubyArrayFromList(requireQueryParams)}).write((Object)"actual_query = CGI.parse(request_uri.query)", new Object[0]).openBlock("require_query.each do |query|", new Object[0]).write((Object)"expect(actual_query.key?(query)).to be true", new Object[0]).closeBlock("end", new Object[0]);
        }
    }

    private void renderResponseStubMiddleware(HttpResponseTestCase testCase) {
        this.writer.openBlock("middleware = Seahorse::MiddlewareBuilder.after_send do |input, context|", new Object[0]).write((Object)"response = context.response", new Object[0]).write((Object)"expect(response.status).to eq($L)", new Object[]{testCase.getCode()}).closeBlock("end", new Object[0]);
    }
}

