/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.List;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyDependency;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class GemspecGenerator {
    private final GenerationContext context;

    public GemspecGenerator(GenerationContext context) {
        this.context = context;
    }

    public void render(List<RubyDependency> additionalDependencies) {
        FileManifest fileManifest = this.context.getFileManifest();
        RubySettings settings = this.context.getRubySettings();
        RubyCodeWriter writer = new RubyCodeWriter();
        writer.writePreamble().openBlock("Gem::Specification.new do |spec|", new Object[0]).write((Object)"spec.name          = '$L'", new Object[]{settings.getGemName()}).write((Object)"spec.version       = '$L'", new Object[]{settings.getGemVersion()}).write((Object)"spec.author        = 'Amazon Web Services'", new Object[0]).write((Object)"spec.summary       = '$L'", new Object[]{settings.getGemSummary()}).write((Object)"spec.files         = Dir['lib/**/*.rb']", new Object[0]).write((Object)"", new Object[0]).write((Object)"spec.add_runtime_dependency 'seahorse', '~> 1.0.0.pre1'", new Object[0]).closeBlock("end", new Object[0]);
        String fileName = settings.getGemName() + "/" + settings.getGemName() + ".gemspec";
        fileManifest.writeFile(fileName, writer.toString());
    }
}

