/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.ErrorTrait;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.RubySymbolProvider;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public abstract class ErrorsGeneratorBase {
    private static final Logger LOGGER = Logger.getLogger(ErrorsGeneratorBase.class.getName());
    protected final GenerationContext context;
    protected final RubySettings settings;
    protected final Model model;
    protected final RubyCodeWriter writer;
    protected final RubyCodeWriter rbsWriter;
    protected final SymbolProvider symbolProvider;
    protected final Set<Shape> errorShapes;

    public ErrorsGeneratorBase(GenerationContext context) {
        this.context = context;
        this.settings = context.getRubySettings();
        this.model = context.getModel();
        this.writer = new RubyCodeWriter();
        this.rbsWriter = new RubyCodeWriter();
        this.symbolProvider = new RubySymbolProvider(this.model, this.settings, "Errors", true);
        this.errorShapes = this.getErrorShapes();
    }

    public void render(FileManifest fileManifest) {
        this.writer.writePreamble().openBlock("module $L", new Object[]{this.settings.getModule()}).openBlock("module Errors", new Object[0]).write((Object)"", new Object[0]).call(() -> this.renderErrorCode()).call(() -> this.renderBaseErrors()).call(() -> this.renderServiceModelErrors()).write((Object)"", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        String fileName = this.settings.getGemName() + "/lib/" + this.settings.getGemName() + "/errors.rb";
        fileManifest.writeFile(fileName, this.writer.toString());
        LOGGER.info("Wrote errors to " + fileName);
    }

    public void renderRbs(FileManifest fileManifest) {
        this.rbsWriter.writePreamble().openBlock("module $L", new Object[]{this.settings.getModule()}).openBlock("module Errors", new Object[0]).write((Object)"", new Object[0]).call(() -> this.renderRbsErrorCode()).call(() -> this.renderRbsBaseErrors()).call(() -> this.renderRbsServiceModelErrors()).write((Object)"", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        String typesFile = this.settings.getGemName() + "/sig/" + this.settings.getGemName() + "/errors.rbs";
        fileManifest.writeFile(typesFile, this.rbsWriter.toString());
        LOGGER.info("Wrote errors rbs to " + typesFile);
    }

    private void renderBaseErrors() {
        this.writer.write("\n# Base class for all errors returned by this service", new Object[0]).write((Object)"class ApiError < Seahorse::HTTP::ApiError; end", new Object[0]).write((Object)"\n# Base class for all errors returned where the client is at fault.", new Object[0]).write((Object)"# These are generally errors with 4XX HTTP status codes.", new Object[0]).write((Object)"class ApiClientError < ApiError; end", new Object[0]).write((Object)"\n# Base class for all errors returned where the server is at fault.", new Object[0]).write((Object)"# These are generally errors with 5XX HTTP status codes.", new Object[0]).write((Object)"class ApiServerError < ApiError; end", new Object[0]).write((Object)"\n# Base class for all errors returned where the service returned", new Object[0]).write((Object)"# a 3XX redirection.", new Object[0]).openBlock("class ApiRedirectError < ApiError", new Object[0]).openBlock("def initialize(location:, **kwargs)", new Object[0]).write((Object)"@location = location", new Object[0]).write((Object)"super(**kwargs)", new Object[0]).closeBlock("end", new Object[0]).write((Object)"", new Object[0]).write((Object)"# @return [String] location", new Object[0]).write((Object)"attr_reader :location", new Object[0]).closeBlock("end", new Object[0]);
        LOGGER.fine("Generated base errors");
    }

    private void renderRbsBaseErrors() {
        this.rbsWriter.write("\nclass ApiError < Seahorse::HTTP::ApiError", new Object[0]).write((Object)"end", new Object[0]).write((Object)"\nclass ApiClientError < ApiError", new Object[0]).write((Object)"end", new Object[0]).write((Object)"\nclass ApiServerError < ApiError", new Object[0]).write((Object)"end", new Object[0]).openBlock("\nclass ApiRedirectError < ApiError", new Object[0]).write((Object)"def initialize: (location: untyped location, **untyped kwargs) -> void\n", new Object[0]).write((Object)"attr_reader location: untyped", new Object[0]).closeBlock("end", new Object[0]);
    }

    public abstract void renderErrorCode();

    public void renderRbsErrorCode() {
        this.rbsWriter.write("def self.error_code: (untyped http_resp) -> untyped", new Object[0]);
    }

    private Set<Shape> getErrorShapes() {
        TopDownIndex topDownIndex = TopDownIndex.of((Model)this.model);
        return topDownIndex.getContainedOperations((ToShapeId)this.context.getService()).stream().map(OperationShape::getErrors).flatMap(Collection::stream).map(arg_0 -> ((Model)this.model).expectShape(arg_0)).collect(Collectors.toSet());
    }

    private void renderServiceModelErrors() {
        this.errorShapes.stream().sorted(Comparator.comparing(o -> o.getId().getName())).forEach(error -> {
            String errorName = this.symbolProvider.toSymbol(error).getName();
            ErrorTrait errorTrait = (ErrorTrait)error.getTrait(ErrorTrait.class).get();
            String apiErrorType = this.getApiErrorType(errorTrait);
            this.renderServiceModelError(errorName, apiErrorType);
        });
    }

    private void renderRbsServiceModelErrors() {
        this.errorShapes.stream().sorted(Comparator.comparing(o -> o.getId().getName())).forEach(error -> {
            String errorName = this.symbolProvider.toSymbol(error).getName();
            ErrorTrait errorTrait = (ErrorTrait)error.getTrait(ErrorTrait.class).get();
            String apiErrorType = this.getApiErrorType(errorTrait);
            this.renderRbsServiceModelError(errorName, apiErrorType);
        });
    }

    private void renderServiceModelError(String errorName, String apiErrorType) {
        this.writer.write("", new Object[0]).openBlock("class $L < $L", new Object[]{errorName, apiErrorType});
        this.writer.writeYardParam("Seahorse::HTTP::Response", "http_resp", "").writeYardParam("String", "error_code", "").writeYardParam("String", "message", "");
        this.writer.openBlock("def initialize(http_resp:, **kwargs)", new Object[0]).write((Object)"@data = Parsers::$L.parse(http_resp)", new Object[]{errorName}).write((Object)"kwargs[:message] = @data.message if @data.respond_to?(:message)\n", new Object[0]).write((Object)"super(http_resp: http_resp, **kwargs)", new Object[0]).closeBlock("end", new Object[0]).write((Object)"", new Object[0]);
        this.writer.writeYardReturn("Types::" + errorName, "").write("attr_reader :data", new Object[0]).closeBlock("end", new Object[0]);
        LOGGER.finest("Generated service model error: " + errorName + " type: " + apiErrorType);
    }

    private void renderRbsServiceModelError(String errorName, String apiErrorType) {
        this.rbsWriter.write("", new Object[0]).openBlock("class $L < $L", new Object[]{errorName, apiErrorType}).write((Object)"def initialize: (http_resp: untyped http_resp, **untyped kwargs) -> void\n", new Object[0]).write((Object)"attr_reader data: untyped", new Object[0]).closeBlock("end", new Object[0]);
    }

    private String getApiErrorType(ErrorTrait errorTrait) {
        String apiErrorType = errorTrait.isClientError() ? "ApiClientError" : (errorTrait.isServerError() ? "ApiServerError" : "Seahorse::ApiError");
        return apiErrorType;
    }
}

